/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.kie.api.runtime.KieSession;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.stream.DroolsConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.stream.drools.SessionDescriptor;
import org.optaplanner.test.impl.score.stream.DefaultMultiConstraintAssertion;
import org.optaplanner.test.impl.score.stream.DefaultSingleConstraintAssertion;
import org.optaplanner.test.impl.score.stream.SessionBasedAssertionBuilder;

final class DroolsSessionBasedAssertionBuilder<Solution_, Score_ extends Score<Score_>>
implements SessionBasedAssertionBuilder<Solution_, Score_> {
    private final DroolsConstraintStreamScoreDirectorFactory<Solution_, Score_> constraintStreamScoreDirectorFactory;

    public DroolsSessionBasedAssertionBuilder(DroolsConstraintStreamScoreDirectorFactory<Solution_, Score_> constraintStreamScoreDirectorFactory) {
        this.constraintStreamScoreDirectorFactory = Objects.requireNonNull(constraintStreamScoreDirectorFactory);
    }

    @Override
    public DefaultMultiConstraintAssertion<Solution_, Score_> multiConstraintGiven(ConstraintProvider constraintProvider, Object ... facts) {
        ScoreInliner<Score_> scoreInliner = this.runSession(facts);
        return new DefaultMultiConstraintAssertion(constraintProvider, scoreInliner.extractScore(0), scoreInliner.getConstraintMatchTotalMap(), scoreInliner.getIndictmentMap());
    }

    @Override
    public DefaultSingleConstraintAssertion<Solution_, Score_> singleConstraintGiven(Object ... facts) {
        this.assertDistinctPlanningIds(this.constraintStreamScoreDirectorFactory.getSolutionDescriptor(), facts);
        ScoreInliner<Score_> scoreInliner = this.runSession(facts);
        return new DefaultSingleConstraintAssertion<Solution_, Score>(this.constraintStreamScoreDirectorFactory, scoreInliner.extractScore(0), scoreInliner.getConstraintMatchTotalMap(), scoreInliner.getIndictmentMap());
    }

    private ScoreInliner<Score_> runSession(Object ... facts) {
        SessionDescriptor sessionDescriptor = this.constraintStreamScoreDirectorFactory.newConstraintStreamingSession(true, null);
        KieSession session = sessionDescriptor.getSession();
        Arrays.stream(facts).forEach(arg_0 -> ((KieSession)session).insert(arg_0));
        session.fireAllRules();
        return sessionDescriptor.getScoreInliner();
    }

    private void assertDistinctPlanningIds(SolutionDescriptor<Solution_> solutionDescriptor, Object ... facts) {
        if (facts.length < 2) {
            return;
        }
        Map entitiesByClassMap = Arrays.stream(facts).filter(fact -> solutionDescriptor.hasEntityDescriptor(fact.getClass())).collect(Collectors.groupingBy(fact -> {
            EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptor(fact.getClass());
            return entityDescriptor.getEntityClass();
        }, ConcurrentHashMap::new, Collectors.toList()));
        entitiesByClassMap.forEach((clz, clzFacts) -> {
            MemberAccessor planningIdAccessor = ConfigUtils.findPlanningIdMemberAccessor((Class)clz, (DomainAccessType)solutionDescriptor.getDomainAccessType(), (Map)solutionDescriptor.getGeneratedMemberAccessorMap());
            if (planningIdAccessor == null) {
                return;
            }
            Map<Optional, List<Object>> entitiesWithSameIdMap = clzFacts.stream().collect(Collectors.groupingBy(fact -> {
                Object planningId = planningIdAccessor.executeGetter(fact);
                return Optional.ofNullable(planningId);
            }));
            Optional<Map.Entry> firstDuplicateIdEntry = entitiesWithSameIdMap.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).findFirst();
            firstDuplicateIdEntry.ifPresent(entry -> {
                String value = ((Optional)entry.getKey()).map(Objects::toString).orElse("null");
                throw new IllegalStateException("Multiple instances of @" + PlanningEntity.class.getSimpleName() + "-annotated class (" + clz.getCanonicalName() + ") share the same @" + PlanningId.class.getSimpleName() + " value (" + value + ").\nThe instances are (" + entry.getValue() + ").\nMake sure that IDs of entities passed into the given(...) method are unique.");
            });
        });
    }
}

