/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.score;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.projectjobscheduling.domain.Allocation;
import org.optaplanner.examples.projectjobscheduling.domain.JobType;
import org.optaplanner.examples.projectjobscheduling.domain.ResourceRequirement;

public class ProjectJobSchedulingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.nonRenewableResourceCapacity(constraintFactory), this.renewableResourceCapacity(constraintFactory), this.totalProjectDelay(constraintFactory), this.totalMakespan(constraintFactory)};
    }

    protected Constraint nonRenewableResourceCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.from(ResourceRequirement.class).filter(resource -> !resource.isResourceRenewable()).join(Allocation.class, Joiners.equal(ResourceRequirement::getExecutionMode, Allocation::getExecutionMode)).groupBy((requirement, allocation) -> requirement.getResource(), ConstraintCollectors.sum((requirement, allocation) -> requirement.getRequirement())).filter((resource, requirements) -> requirements > resource.getCapacity()).penalize("Non-renewable resource capacity", (Score)HardMediumSoftScore.ofHard((int)1), (resource, requirements) -> requirements - resource.getCapacity());
    }

    protected Constraint renewableResourceCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.from(ResourceRequirement.class).filter(ResourceRequirement::isResourceRenewable).join(Allocation.class, Joiners.equal(ResourceRequirement::getExecutionMode, Allocation::getExecutionMode)).flattenLast(a -> IntStream.range(a.getStartDate(), a.getEndDate()).boxed().collect(Collectors.toList())).groupBy((resourceReq, date) -> resourceReq.getResource(), (resourceReq, date) -> date, ConstraintCollectors.sum((resourceReq, date) -> resourceReq.getRequirement())).filter((resourceReq, date, totalRequirement) -> totalRequirement > resourceReq.getCapacity()).penalize("Renewable resource capacity", (Score)HardMediumSoftScore.ofHard((int)1), (resourceReq, date, totalRequirement) -> totalRequirement - resourceReq.getCapacity());
    }

    protected Constraint totalProjectDelay(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Allocation.class).filter(allocation -> allocation.getEndDate() != null).filter(allocation -> allocation.getJobType() == JobType.SINK).impact("Total project delay", (Score)HardMediumSoftScore.ofMedium((int)1), allocation -> allocation.getProjectCriticalPathEndDate() - allocation.getEndDate());
    }

    protected Constraint totalMakespan(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Allocation.class).filter(allocation -> allocation.getEndDate() != null).filter(allocation -> allocation.getJobType() == JobType.SINK).groupBy(ConstraintCollectors.max(Allocation::getEndDate)).penalize("Total makespan", (Score)HardMediumSoftScore.ofSoft((int)1), maxEndDate -> maxEndDate);
    }
}

