/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.SourcedVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotificationType;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.Supply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class VariableListenerSupport<Solution_>
implements SupplyManager<Solution_> {
    protected final InnerScoreDirector<Solution_, ?> scoreDirector;
    protected final List<VariableListenerNotifiable> notifiableList;
    protected final Map<VariableDescriptor<Solution_>, List<VariableListenerNotifiable>> sourceVariableToNotifiableMap;
    protected final Map<EntityDescriptor<Solution_>, List<VariableListenerNotifiable>> sourceEntityToNotifiableMap;
    protected final Map<Demand<Solution_, ?>, Supply> supplyMap;
    protected int nextGlobalOrder = 0;
    protected boolean notificationQueuesAreEmpty;

    public VariableListenerSupport(InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.scoreDirector = scoreDirector;
        this.notifiableList = new ArrayList<VariableListenerNotifiable>();
        this.sourceVariableToNotifiableMap = new LinkedHashMap<VariableDescriptor<Solution_>, List<VariableListenerNotifiable>>();
        this.sourceEntityToNotifiableMap = new LinkedHashMap<EntityDescriptor<Solution_>, List<VariableListenerNotifiable>>();
        this.supplyMap = new LinkedHashMap();
    }

    public void linkVariableListeners() {
        this.notificationQueuesAreEmpty = true;
        for (EntityDescriptor<Solution_> entityDescriptor : this.scoreDirector.getSolutionDescriptor().getEntityDescriptors()) {
            for (VariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                this.sourceVariableToNotifiableMap.put(variableDescriptor, new ArrayList());
            }
            this.sourceEntityToNotifiableMap.put(entityDescriptor, new ArrayList());
        }
        for (EntityDescriptor<Solution_> entityDescriptor : this.scoreDirector.getSolutionDescriptor().getEntityDescriptors()) {
            for (ShadowVariableDescriptor shadowVariableDescriptor : entityDescriptor.getDeclaredShadowVariableDescriptors()) {
                int globalOrder;
                if (!shadowVariableDescriptor.hasVariableListener(this.scoreDirector)) continue;
                VariableListener<Solution_, ?> variableListener = shadowVariableDescriptor.buildVariableListener(this.scoreDirector);
                if (variableListener instanceof Supply) {
                    this.supplyMap.put(shadowVariableDescriptor.getProvidedDemand(), (Supply)((Object)variableListener));
                }
                if (this.nextGlobalOrder <= (globalOrder = shadowVariableDescriptor.getGlobalShadowOrder())) {
                    this.nextGlobalOrder = globalOrder + 1;
                }
                VariableListenerNotifiable notifiable = new VariableListenerNotifiable(variableListener, globalOrder);
                for (VariableDescriptor source : shadowVariableDescriptor.getSourceVariableDescriptorList()) {
                    List<VariableListenerNotifiable> variableNotifiableList = this.sourceVariableToNotifiableMap.get(source);
                    variableNotifiableList.add(notifiable);
                    List<VariableListenerNotifiable> entityNotifiableList = this.sourceEntityToNotifiableMap.get(source.getEntityDescriptor());
                    if (entityNotifiableList.contains(notifiable)) continue;
                    entityNotifiableList.add(notifiable);
                }
                this.notifiableList.add(notifiable);
            }
        }
        Collections.sort(this.notifiableList);
    }

    @Override
    public <Supply_ extends Supply> Supply_ demand(Demand<Solution_, Supply_> demand) {
        Supply supply = this.supplyMap.get(demand);
        if (supply == null) {
            supply = demand.createExternalizedSupply(this.scoreDirector);
            if (supply instanceof SourcedVariableListener) {
                SourcedVariableListener variableListener = (SourcedVariableListener)supply;
                if (this.scoreDirector.getWorkingSolution() != null) {
                    variableListener.resetWorkingSolution(this.scoreDirector);
                }
                VariableDescriptor source = variableListener.getSourceVariableDescriptor();
                VariableListenerNotifiable notifiable = new VariableListenerNotifiable(variableListener, this.nextGlobalOrder);
                ++this.nextGlobalOrder;
                List<VariableListenerNotifiable> variableNotifiableList = this.sourceVariableToNotifiableMap.get(source);
                variableNotifiableList.add(notifiable);
                List<VariableListenerNotifiable> entityNotifiableList = this.sourceEntityToNotifiableMap.get(source.getEntityDescriptor());
                if (!entityNotifiableList.contains(notifiable)) {
                    entityNotifiableList.add(notifiable);
                }
                this.notifiableList.add(notifiable);
            }
            this.supplyMap.put(demand, supply);
        }
        return (Supply_)supply;
    }

    public void resetWorkingSolution() {
        for (VariableListenerNotifiable notifiable : this.notifiableList) {
            VariableListener variableListener = notifiable.getVariableListener();
            variableListener.resetWorkingSolution(this.scoreDirector);
        }
    }

    public void clearWorkingSolution() {
        for (VariableListenerNotifiable notifiable : this.notifiableList) {
            VariableListener variableListener = notifiable.getVariableListener();
            variableListener.close();
        }
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        List<VariableListenerNotifiable> notifiableList = this.sourceEntityToNotifiableMap.get(entityDescriptor);
        for (VariableListenerNotifiable notifiable : notifiableList) {
            Collection<VariableListenerNotification> notificationQueue = notifiable.getNotificationQueue();
            boolean added = notificationQueue.add(new VariableListenerNotification(entity, VariableListenerNotificationType.ENTITY_ADDED));
            if (!added) continue;
            notifiable.getVariableListener().beforeEntityAdded(this.scoreDirector, entity);
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
    }

    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        List notifiableList = this.sourceVariableToNotifiableMap.getOrDefault(variableDescriptor, Collections.emptyList());
        for (VariableListenerNotifiable notifiable : notifiableList) {
            Collection<VariableListenerNotification> notificationQueue = notifiable.getNotificationQueue();
            boolean added = notificationQueue.add(new VariableListenerNotification(entity, VariableListenerNotificationType.VARIABLE_CHANGED));
            if (!added) continue;
            notifiable.getVariableListener().beforeVariableChanged(this.scoreDirector, entity);
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        List<VariableListenerNotifiable> notifiableList = this.sourceEntityToNotifiableMap.get(entityDescriptor);
        for (VariableListenerNotifiable notifiable : notifiableList) {
            Collection<VariableListenerNotification> notificationQueue = notifiable.getNotificationQueue();
            boolean added = notificationQueue.add(new VariableListenerNotification(entity, VariableListenerNotificationType.ENTITY_REMOVED));
            if (!added) continue;
            notifiable.getVariableListener().beforeEntityRemoved(this.scoreDirector, entity);
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
    }

    public void triggerVariableListenersInNotificationQueues() {
        for (VariableListenerNotifiable notifiable : this.notifiableList) {
            Collection<VariableListenerNotification> notificationQueue = notifiable.getNotificationQueue();
            int notifiedCount = 0;
            VariableListener variableListener = notifiable.getVariableListener();
            for (VariableListenerNotification notification : notificationQueue) {
                Object entity = notification.getEntity();
                switch (notification.getType()) {
                    case ENTITY_ADDED: {
                        variableListener.afterEntityAdded(this.scoreDirector, entity);
                        break;
                    }
                    case VARIABLE_CHANGED: {
                        variableListener.afterVariableChanged(this.scoreDirector, entity);
                        break;
                    }
                    case ENTITY_REMOVED: {
                        variableListener.afterEntityRemoved(this.scoreDirector, entity);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The variableListenerNotificationType (" + notification.getType() + ") is not implemented.");
                    }
                }
                ++notifiedCount;
            }
            if (notifiedCount != notificationQueue.size()) {
                throw new IllegalStateException("The variableListener (" + variableListener.getClass() + ") has been notified with notifiedCount (" + notifiedCount + ") but after notification it has different size (" + notificationQueue.size() + ").\nMaybe that variableListener (" + variableListener.getClass() + ") changed an upstream shadow variable (which is illegal).");
            }
            notificationQueue.clear();
        }
        this.notificationQueuesAreEmpty = true;
    }

    public void triggerAllVariableListeners() {
        SolutionDescriptor<Solution_> solutionDescriptor = this.scoreDirector.getSolutionDescriptor();
        List<Object> entityList = this.scoreDirector.getWorkingEntityList();
        for (Object entity : entityList) {
            EntityDescriptor<Solution_> entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
                this.beforeVariableChanged(variableDescriptor, entity);
                this.afterVariableChanged(variableDescriptor, entity);
            }
        }
        this.triggerVariableListenersInNotificationQueues();
    }

    public void assertNotificationQueuesAreEmpty() {
        if (!this.notificationQueuesAreEmpty) {
            throw new IllegalStateException("The notificationQueues might not be empty (" + this.notificationQueuesAreEmpty + ") so any shadow variables might be stale so score calculation is unreliable.\nMaybe a " + ScoreDirector.class.getSimpleName() + ".before*() method was called without calling " + ScoreDirector.class.getSimpleName() + ".triggerVariableListeners(), before calling " + ScoreDirector.class.getSimpleName() + ".calculateScore().");
        }
    }
}

