/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.partitionedsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.partitionedsearch.PartitionSolver;
import org.optaplanner.core.impl.partitionedsearch.PartitionedSearchPhase;
import org.optaplanner.core.impl.partitionedsearch.event.PartitionedSearchPhaseLifecycleListener;
import org.optaplanner.core.impl.partitionedsearch.partitioner.SolutionPartitioner;
import org.optaplanner.core.impl.partitionedsearch.queue.PartitionQueue;
import org.optaplanner.core.impl.partitionedsearch.scope.PartitionChangeMove;
import org.optaplanner.core.impl.partitionedsearch.scope.PartitionedSearchPhaseScope;
import org.optaplanner.core.impl.partitionedsearch.scope.PartitionedSearchStepScope;
import org.optaplanner.core.impl.phase.AbstractPhase;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.phase.PhaseFactory;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecallerFactory;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.solver.termination.ChildThreadPlumbingTermination;
import org.optaplanner.core.impl.solver.termination.OrCompositeTermination;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;
import org.optaplanner.core.impl.solver.thread.ThreadUtils;

public class DefaultPartitionedSearchPhase<Solution_>
extends AbstractPhase<Solution_>
implements PartitionedSearchPhase<Solution_>,
PartitionedSearchPhaseLifecycleListener<Solution_> {
    protected final SolutionPartitioner<Solution_> solutionPartitioner;
    protected final ThreadFactory threadFactory;
    protected final Integer runnablePartThreadLimit;
    protected List<PhaseConfig> phaseConfigList;
    protected HeuristicConfigPolicy<Solution_> configPolicy;

    public DefaultPartitionedSearchPhase(int phaseIndex, String logIndentation, Termination<Solution_> termination, SolutionPartitioner<Solution_> solutionPartitioner, ThreadFactory threadFactory, Integer runnablePartThreadLimit) {
        super(phaseIndex, logIndentation, termination);
        this.solutionPartitioner = solutionPartitioner;
        this.threadFactory = threadFactory;
        this.runnablePartThreadLimit = runnablePartThreadLimit;
    }

    public void setPhaseConfigList(List<PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
    }

    public void setConfigPolicy(HeuristicConfigPolicy<Solution_> configPolicy) {
        this.configPolicy = configPolicy;
    }

    @Override
    public String getPhaseTypeString() {
        return "Partitioned Search";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(SolverScope<Solution_> solverScope) {
        PartitionedSearchPhaseScope<Solution_> phaseScope = new PartitionedSearchPhaseScope<Solution_>(solverScope);
        List<Solution_> partList = this.solutionPartitioner.splitWorkingSolution(solverScope.getScoreDirector(), this.runnablePartThreadLimit);
        int partCount = partList.size();
        phaseScope.setPartCount(partCount);
        this.phaseStarted(phaseScope);
        ExecutorService executor = this.createThreadPoolExecutor(partCount);
        ChildThreadPlumbingTermination childThreadPlumbingTermination = new ChildThreadPlumbingTermination();
        PartitionQueue partitionQueue = new PartitionQueue(partCount);
        Semaphore runnablePartThreadSemaphore = this.runnablePartThreadLimit == null ? null : new Semaphore(this.runnablePartThreadLimit, true);
        try {
            ListIterator<Solution_> it = partList.listIterator();
            while (it.hasNext()) {
                int partIndex = it.nextIndex();
                Solution_ part = it.next();
                PartitionSolver partitionSolver = this.buildPartitionSolver(childThreadPlumbingTermination, runnablePartThreadSemaphore, solverScope);
                partitionSolver.addEventListener(event -> {
                    InnerScoreDirector childScoreDirector = partitionSolver.solverScope.getScoreDirector();
                    Move move = PartitionChangeMove.createMove(childScoreDirector, partIndex);
                    InnerScoreDirector parentScoreDirector = solverScope.getScoreDirector();
                    move = move.rebase((ScoreDirector)parentScoreDirector);
                    partitionQueue.addMove(partIndex, move);
                });
                executor.submit(() -> {
                    try {
                        partitionSolver.solve(part);
                        long partCalculationCount = partitionSolver.getScoreCalculationCount();
                        partitionQueue.addFinish(partIndex, partCalculationCount);
                    }
                    catch (Throwable throwable) {
                        this.logger.trace("{}            Part thread ({}) exception that will be propagated to the solver thread.", new Object[]{this.logIndentation, partIndex, throwable});
                        partitionQueue.addExceptionThrown(partIndex, throwable);
                    }
                });
            }
            for (PartitionChangeMove step : partitionQueue) {
                PartitionedSearchStepScope stepScope = new PartitionedSearchStepScope(phaseScope);
                this.stepStarted(stepScope);
                stepScope.setStep(step);
                if (this.logger.isDebugEnabled()) {
                    stepScope.setStepString(step.toString());
                }
                this.doStep(stepScope);
                this.stepEnded(stepScope);
                phaseScope.setLastCompletedStepScope(stepScope);
            }
            phaseScope.addChildThreadsScoreCalculationCount(partitionQueue.getPartsCalculationCount());
        }
        finally {
            childThreadPlumbingTermination.terminateChildren();
            ThreadUtils.shutdownAwaitOrKill(executor, this.logIndentation, "Partitioned Search");
        }
        this.phaseEnded(phaseScope);
    }

    private ExecutorService createThreadPoolExecutor(int partCount) {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(partCount, this.threadFactory);
        if (threadPoolExecutor.getMaximumPoolSize() < partCount) {
            throw new IllegalStateException("The threadPoolExecutor's maximumPoolSize (" + threadPoolExecutor.getMaximumPoolSize() + ") is less than the partCount (" + partCount + "), so some partitions will starve.\nNormally this is impossible because the threadPoolExecutor should be unbounded. Use runnablePartThreadLimit (" + this.runnablePartThreadLimit + ") instead to avoid CPU hogging and live locks.");
        }
        return threadPoolExecutor;
    }

    public PartitionSolver<Solution_> buildPartitionSolver(ChildThreadPlumbingTermination<Solution_> childThreadPlumbingTermination, Semaphore runnablePartThreadSemaphore, SolverScope<Solution_> solverScope) {
        BestSolutionRecaller bestSolutionRecaller = BestSolutionRecallerFactory.create().buildBestSolutionRecaller(this.configPolicy.getEnvironmentMode());
        OrCompositeTermination partTermination = new OrCompositeTermination(childThreadPlumbingTermination, this.phaseTermination.createChildThreadTermination(solverScope, ChildThreadType.PART_THREAD));
        ArrayList phaseList = new ArrayList(this.phaseConfigList.size());
        int partPhaseIndex = 0;
        for (PhaseConfig phaseConfig : this.phaseConfigList) {
            PhaseFactory<Solution_> phaseFactory = PhaseFactory.create(phaseConfig);
            Phase phase = phaseFactory.buildPhase(partPhaseIndex, this.configPolicy, bestSolutionRecaller, partTermination);
            phaseList.add(phase);
            ++partPhaseIndex;
        }
        SolverScope<Solution_> partSolverScope = solverScope.createChildThreadSolverScope(ChildThreadType.PART_THREAD);
        partSolverScope.setRunnableThreadSemaphore(runnablePartThreadSemaphore);
        return new PartitionSolver(bestSolutionRecaller, partTermination, phaseList, partSolverScope);
    }

    protected void doStep(PartitionedSearchStepScope<Solution_> stepScope) {
        PartitionChangeMove<Solution_> nextStep = stepScope.getStep();
        nextStep.doMove(stepScope.getScoreDirector());
        this.calculateWorkingStepScore(stepScope, nextStep);
        this.solver.getBestSolutionRecaller().processWorkingSolutionDuringStep(stepScope);
    }

    @Override
    public void phaseStarted(PartitionedSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(PartitionedSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(PartitionedSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}    PS step ({}), time spent ({}), score ({}), {} best score ({}), picked move ({}).", new Object[]{this.logIndentation, stepScope.getStepIndex(), phaseScope.calculateSolverTimeMillisSpentUpToNow(), stepScope.getScore(), stepScope.getBestScoreImproved() != false ? "new" : "   ", phaseScope.getBestScore(), stepScope.getStepString()});
        }
    }

    @Override
    public void phaseEnded(PartitionedSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        phaseScope.endingNow();
        this.logger.info("{}Partitioned Search phase ({}) ended: time spent ({}), best score ({}), score calculation speed ({}/sec), step total ({}), partCount ({}), runnablePartThreadLimit ({}).", new Object[]{this.logIndentation, this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore(), phaseScope.getPhaseScoreCalculationSpeed(), phaseScope.getNextStepIndex(), phaseScope.getPartCount(), this.runnablePartThreadLimit});
    }
}

