/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.definition;

import java.util.Map;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public interface ScoreDefinition<Score_ extends Score<Score_>> {
    public String getInitLabel();

    public int getLevelsSize();

    public int getFeasibleLevelsSize();

    public String[] getLevelLabels();

    public Class<Score_> getScoreClass();

    public Score_ getZeroScore();

    public Score_ getOneSoftestScore();

    default public boolean isPositiveOrZero(Score_ score) {
        return score.compareTo(this.getZeroScore()) >= 0;
    }

    default public boolean isNegativeOrZero(Score_ score) {
        return score.compareTo(this.getZeroScore()) <= 0;
    }

    public String formatScore(Score_ var1);

    public Score_ parseScore(String var1);

    public Score_ fromLevelNumbers(int var1, Number[] var2);

    public ScoreInliner<Score_> buildScoreInliner(Map<Constraint, Score_> var1, boolean var2);

    public AbstractScoreHolder<Score_> buildScoreHolder(boolean var1);

    public Score_ buildOptimisticBound(InitializingScoreTrend var1, Score_ var2);

    public Score_ buildPessimisticBound(InitializingScoreTrend var1, Score_ var2);

    public Score_ divideBySanitizedDivisor(Score_ var1, Score_ var2);

    public boolean isCompatibleArithmeticArgument(Score var1);
}

