/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Function;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.penta.PentaJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.common.ScoreImpactType;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsGroupingBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.common.QuadLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.RuleBuilder;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsExistsQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsFilterQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsFlatteningQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsGroupingQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsGroupingTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsGroupingUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsMappingUniConstraintStream;
import org.optaplanner.core.impl.score.stream.quad.InnerQuadConstraintStream;

public abstract class DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D>
extends DroolsAbstractConstraintStream<Solution_>
implements InnerQuadConstraintStream<A, B, C, D> {
    public DroolsAbstractQuadConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory) {
        super(constraintFactory);
    }

    @Override
    public QuadConstraintStream<A, B, C, D> filter(QuadPredicate<A, B, C, D> predicate) {
        DroolsFilterQuadConstraintStream stream = new DroolsFilterQuadConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    @SafeVarargs
    public final <E> QuadConstraintStream<A, B, C, D> ifExists(Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return this.ifExistsOrNot(true, otherClass, joiners);
    }

    @Override
    @SafeVarargs
    public final <E> QuadConstraintStream<A, B, C, D> ifNotExists(Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return this.ifExistsOrNot(false, otherClass, joiners);
    }

    @SafeVarargs
    private final <E> QuadConstraintStream<A, B, C, D> ifExistsOrNot(boolean shouldExist, Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        this.getConstraintFactory().assertValidFromType(otherClass);
        DroolsExistsQuadConstraintStream stream = new DroolsExistsQuadConstraintStream(this.constraintFactory, this, shouldExist, otherClass, joiners);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> collector) {
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(QuadConstraintCollector<A, B, C, D, ResultContainerA_, ResultA_> collectorA, QuadConstraintCollector<A, B, C, D, ResultContainerB_, ResultB_> collectorB) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, collectorA, collectorB);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(QuadConstraintCollector<A, B, C, D, ResultContainerA_, ResultA_> collectorA, QuadConstraintCollector<A, B, C, D, ResultContainerB_, ResultB_> collectorB, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, collectorA, collectorB, collectorC);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(QuadConstraintCollector<A, B, C, D, ResultContainerA_, ResultA_> collectorA, QuadConstraintCollector<A, B, C, D, ResultContainerB_, ResultB_> collectorB, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC, QuadConstraintCollector<A, B, C, D, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, collectorA, collectorB, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(QuadFunction<A, B, C, D, GroupKey_> groupKeyMapping) {
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, groupKeyMapping);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(QuadFunction<A, B, C, D, GroupKey_> groupKeyMapping, QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> collector) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(QuadFunction<A, B, C, D, GroupKey_> groupKeyMapping, QuadConstraintCollector<A, B, C, D, ResultContainerB_, ResultB_> collectorB, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyMapping, collectorB, collectorC);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(QuadFunction<A, B, C, D, GroupKey_> groupKeyMapping, QuadConstraintCollector<A, B, C, D, ResultContainerB_, ResultB_> collectorB, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC, QuadConstraintCollector<A, B, C, D, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyMapping, collectorB, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> collector) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC, QuadConstraintCollector<A, B, C, D, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadFunction<A, B, C, D, GroupKeyC_> groupKeyCMapping) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, groupKeyCMapping);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadFunction<A, B, C, D, GroupKeyC_> groupKeyCMapping, QuadConstraintCollector<A, B, C, D, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, groupKeyCMapping, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadFunction<A, B, C, D, GroupKeyC_> groupKeyCMapping, QuadFunction<A, B, C, D, GroupKeyD_> groupKeyDMapping) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, groupKeyCMapping, groupKeyDMapping);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultA_> UniConstraintStream<ResultA_> map(QuadFunction<A, B, C, D, ResultA_> mapping) {
        DroolsMappingUniConstraintStream stream = new DroolsMappingUniConstraintStream(this.constraintFactory, this, Objects.requireNonNull(mapping));
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultD_> QuadConstraintStream<A, B, C, ResultD_> flattenLast(Function<D, Iterable<ResultD_>> mapping) {
        DroolsFlatteningQuadConstraintStream stream = new DroolsFlatteningQuadConstraintStream(this.constraintFactory, this, Objects.requireNonNull(mapping));
        this.addChildStream(stream);
        return stream;
    }

    @Override
    protected Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate();
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, ruleBuilder);
    }

    @Override
    public Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntQuadFunction<A, B, C, D> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, ruleBuilder);
    }

    @Override
    public Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongQuadFunction<A, B, C, D> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, ruleBuilder);
    }

    @Override
    public Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, QuadFunction<A, B, C, D, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, ruleBuilder);
    }

    @Override
    protected Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate();
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, ruleBuilder);
    }

    @Override
    public Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntQuadFunction<A, B, C, D> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, ruleBuilder);
    }

    @Override
    public Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongQuadFunction<A, B, C, D> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, ruleBuilder);
    }

    @Override
    public Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, QuadFunction<A, B, C, D, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, ruleBuilder);
    }

    public abstract QuadLeftHandSide<A, B, C, D> getLeftHandSide();
}

