/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.time.DayOfWeek;
import java.util.Comparator;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.Shift;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.ShiftType;
import org.optaplanner.examples.nurserostering.domain.WeekendDefinition;
import org.optaplanner.examples.nurserostering.domain.contract.Contract;
import org.optaplanner.examples.nurserostering.domain.solver.EmployeeStrengthComparator;
import org.optaplanner.examples.nurserostering.domain.solver.ShiftAssignmentDifficultyComparator;
import org.optaplanner.examples.nurserostering.domain.solver.ShiftAssignmentPinningFilter;

@PlanningEntity(pinningFilter=ShiftAssignmentPinningFilter.class, difficultyComparatorClass=ShiftAssignmentDifficultyComparator.class)
@XStreamAlias(value="ShiftAssignment")
public class ShiftAssignment
extends AbstractPersistable
implements Comparable<ShiftAssignment> {
    private static final Comparator<Shift> COMPARATOR = Comparator.comparing(Shift::getShiftDate).thenComparing(a -> a.getShiftType().getStartTimeString()).thenComparing(a -> a.getShiftType().getEndTimeString());
    private Shift shift;
    private int indexInShift;
    @PlanningVariable(valueRangeProviderRefs={"employeeRange"}, strengthComparatorClass=EmployeeStrengthComparator.class)
    private Employee employee;

    public Shift getShift() {
        return this.shift;
    }

    public void setShift(Shift shift) {
        this.shift = shift;
    }

    public int getIndexInShift() {
        return this.indexInShift;
    }

    public void setIndexInShift(int indexInShift) {
        this.indexInShift = indexInShift;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public ShiftDate getShiftDate() {
        return this.shift.getShiftDate();
    }

    public ShiftType getShiftType() {
        return this.shift.getShiftType();
    }

    public int getShiftDateDayIndex() {
        return this.shift.getShiftDate().getDayIndex();
    }

    public DayOfWeek getShiftDateDayOfWeek() {
        return this.shift.getShiftDate().getDayOfWeek();
    }

    public Contract getContract() {
        if (this.employee == null) {
            return null;
        }
        return this.employee.getContract();
    }

    public boolean isWeekend() {
        if (this.employee == null) {
            return false;
        }
        WeekendDefinition weekendDefinition = this.employee.getContract().getWeekendDefinition();
        DayOfWeek dayOfWeek = this.shift.getShiftDate().getDayOfWeek();
        return weekendDefinition.isWeekend(dayOfWeek);
    }

    public int getWeekendSundayIndex() {
        return this.shift.getShiftDate().getWeekendSundayIndex();
    }

    @Override
    public String toString() {
        return this.shift.toString();
    }

    @Override
    public int compareTo(ShiftAssignment o) {
        return COMPARATOR.compare(this.shift, o.shift);
    }
}

