/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JPanel;
import org.apache.commons.text.WordUtils;
import org.optaplanner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.optaplanner.examples.rocktour.domain.RockBus;
import org.optaplanner.examples.rocktour.domain.RockLocation;
import org.optaplanner.examples.rocktour.domain.RockShow;
import org.optaplanner.examples.rocktour.domain.RockTourSolution;
import org.optaplanner.examples.rocktour.swingui.RockTourPanel;
import org.optaplanner.swing.impl.TangoColorFactory;

public class RockTourWorldPanel
extends JPanel {
    private static final int TEXT_SIZE = 12;
    private static final int LOCATION_NAME_TEXT_SIZE = 8;
    protected static final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("E yyyy-MM-dd", Locale.ENGLISH);
    private final RockTourPanel rockTourPanel;
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;

    public RockTourWorldPanel(RockTourPanel rockTourPanel) {
        this.rockTourPanel = rockTourPanel;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RockTourSolution solution = (RockTourSolution)RockTourWorldPanel.this.rockTourPanel.getSolution();
                if (solution != null) {
                    RockTourWorldPanel.this.resetPanel(solution);
                }
            }
        });
    }

    public void resetPanel(RockTourSolution solution) {
        this.translator = new LatitudeLongitudeTranslator();
        RockBus bus = solution.getBus();
        this.translator.addCoordinates(bus.getStartLocation().getLatitude(), bus.getStartLocation().getLongitude());
        this.translator.addCoordinates(bus.getEndLocation().getLatitude(), bus.getEndLocation().getLongitude());
        for (RockShow show2 : solution.getShowList()) {
            this.translator.addCoordinates(show2.getLocation().getLatitude(), show2.getLocation().getLongitude());
        }
        Dimension size = this.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height);
        Graphics2D g = this.createCanvas(width, height);
        g.setFont(g.getFont().deriveFont(8.0f));
        List<RockShow> showList = solution.getShowList();
        int maxAvailableDateSetSize = showList.stream().mapToInt(show -> show.getAvailableDateSet().size()).max().orElse(-1);
        for (RockShow show3 : showList) {
            RockLocation location = show3.getLocation();
            int x = this.translator.translateLongitudeToX(location.getLongitude());
            int y = this.translator.translateLatitudeToY(location.getLatitude());
            double percentage = (double)show3.getAvailableDateSet().size() / (double)maxAvailableDateSetSize;
            g.setColor(TangoColorFactory.buildPercentageColor((Color)TangoColorFactory.PLUM_3, (Color)TangoColorFactory.PLUM_1, (double)percentage));
            g.fillRect(x - 1, y - 1, 3, 3);
            if (location.getCityName() != null && showList.size() <= 500) {
                g.drawString(WordUtils.abbreviate((String)location.getCityName(), (int)20, (int)-1, (String)"..."), x + 3, y - 3);
            }
            if (show3.getDate() == null) continue;
            g.drawString(DAY_FORMATTER.format(show3.getDate()), x + 3, y - 3 + 12);
        }
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        RockLocation busStartLocation = bus.getStartLocation();
        int domicileX = this.translator.translateLongitudeToX(busStartLocation.getLongitude());
        int domicileY = this.translator.translateLatitudeToY(busStartLocation.getLatitude());
        g.fillRect(domicileX - 2, domicileY - 2, 5, 5);
        if (busStartLocation.getCityName() != null && showList.size() <= 500) {
            g.drawString(busStartLocation.getCityName(), domicileX + 3, domicileY - 3);
        }
        HashSet<RockShow> needsBackToDomicileLineSet = new HashSet<RockShow>(showList);
        for (RockShow trailingShow : showList) {
            if (!(trailingShow.getPreviousStandstill() instanceof RockShow)) continue;
            needsBackToDomicileLineSet.remove(trailingShow.getPreviousStandstill());
        }
        g.setColor(TangoColorFactory.CHOCOLATE_1);
        for (RockShow show4 : showList) {
            if (show4.getPreviousStandstill() == null) continue;
            RockLocation previousLocation = show4.getPreviousStandstill().getDepartureLocation();
            RockLocation location = show4.getLocation();
            this.translator.drawRoute(g, previousLocation.getLongitude(), previousLocation.getLatitude(), location.getLongitude(), location.getLatitude(), true, false);
            if (!needsBackToDomicileLineSet.contains(show4)) continue;
            this.translator.drawRoute(g, location.getLongitude(), location.getLatitude(), busStartLocation.getLongitude(), busStartLocation.getLatitude(), true, true);
        }
        g.setFont(g.getFont().deriveFont(12.0f));
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        g.fillRect(5, (int)height - 17 - 12, 5, 5);
        g.drawString("Bus start", 15, (int)height - 10 - 12);
        g.setColor(TangoColorFactory.PLUM_2);
        g.fillRect(6, (int)height - 11, 3, 3);
        g.drawString("Show (darker means less available)", 15, (int)height - 5);
        this.repaint();
    }

    public void updatePanel(RockTourSolution solution) {
        this.resetPanel(solution);
    }

    private Graphics2D createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics2D g = this.canvas.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.canvas != null) {
            g.drawImage(this.canvas, 0, 0, this);
        }
    }
}

