/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoft;

import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;

public final class HardSoftScoreInliner
extends ScoreInliner<HardSoftScore> {
    private int hardScore;
    private int softScore;

    protected HardSoftScoreInliner(Map<Constraint, HardSoftScore> constraintIdToWeightMap, boolean constraintMatchEnabled) {
        super(constraintIdToWeightMap, constraintMatchEnabled);
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        HardSoftScore constraintWeight = (HardSoftScore)this.getConstraintWeight(constraint);
        int hardConstraintWeight = constraintWeight.getHardScore();
        int softConstraintWeight = constraintWeight.getSoftScore();
        if (softConstraintWeight == 0) {
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                int hardImpact = hardConstraintWeight * matchWeight;
                this.hardScore += hardImpact;
                UndoScoreImpacter undoScoreImpact = () -> this.hardScore -= hardImpact;
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardSoftScore.ofHard(hardImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        if (hardConstraintWeight == 0) {
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                int softImpact = softConstraintWeight * matchWeight;
                this.softScore += softImpact;
                UndoScoreImpacter undoScoreImpact = () -> this.softScore -= softImpact;
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardSoftScore.ofSoft(softImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            int hardImpact = hardConstraintWeight * matchWeight;
            int softImpact = softConstraintWeight * matchWeight;
            this.hardScore += hardImpact;
            this.softScore += softImpact;
            UndoScoreImpacter undoScoreImpact = () -> {
                this.hardScore -= hardImpact;
                this.softScore -= softImpact;
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardSoftScore.of(hardImpact, softImpact), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public HardSoftScore extractScore(int initScore) {
        return HardSoftScore.ofUninitialized(initScore, this.hardScore, this.softScore);
    }

    public String toString() {
        return HardSoftScore.class.getSimpleName() + " inliner";
    }
}

