/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.uni;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniTuple;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFilterUniTuple;

public final class BavetFilterUniNode<A>
extends BavetAbstractUniNode<A> {
    private final BavetAbstractUniNode<A> parentNode;
    private final Predicate<A> predicate;
    private List<BavetAbstractUniNode<A>> childNodeList = new ArrayList<BavetAbstractUniNode<A>>();

    public BavetFilterUniNode(BavetConstraintSession session, int nodeIndex, BavetAbstractUniNode<A> parentNode, Predicate<A> predicate) {
        super(session, nodeIndex);
        this.parentNode = parentNode;
        this.predicate = predicate;
    }

    @Override
    public void addChildNode(BavetAbstractUniNode<A> childNode) {
        this.childNodeList.add(childNode);
    }

    @Override
    public List<BavetAbstractUniNode<A>> getChildNodeList() {
        return this.childNodeList;
    }

    public int hashCode() {
        return Objects.hash(System.identityHashCode(this.parentNode), System.identityHashCode(this.predicate));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFilterUniNode) {
            BavetFilterUniNode other = (BavetFilterUniNode)o;
            return this.parentNode == other.parentNode && this.predicate == other.predicate;
        }
        return false;
    }

    @Override
    public BavetFilterUniTuple<A> createTuple(BavetAbstractUniTuple<A> parentTuple) {
        return new BavetFilterUniTuple<A>(this, parentTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetFilterUniTuple tuple = (BavetFilterUniTuple)uncastTuple;
        Object a = tuple.getFactA();
        List<BavetAbstractTuple> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractTuple bavetAbstractTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive() && this.predicate.test(a)) {
            for (BavetAbstractUniNode bavetAbstractUniNode : this.childNodeList) {
                BavetAbstractUniTuple childTuple = bavetAbstractUniNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public String toString() {
        return "Filter() with " + this.childNodeList.size() + " children";
    }
}

