/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.extractors;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.core.base.ValueType;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.spi.AcceptsReadAccessor;
import org.drools.core.spi.ClassWireable;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.MathUtils;
import org.drools.core.util.StringUtils;

public class ArrayElementReader
implements AcceptsReadAccessor,
InternalReadAccessor,
ClassWireable,
Externalizable {
    private InternalReadAccessor arrayReadAccessor;
    private int index;
    private Class type;

    public ArrayElementReader() {
    }

    public ArrayElementReader(InternalReadAccessor arrayExtractor, int index, Class<?> type) {
        this.arrayReadAccessor = arrayExtractor;
        this.index = index;
        this.type = type;
    }

    @Override
    public Class<?> getExtractToClass() {
        return this.type;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.arrayReadAccessor = (InternalReadAccessor)in.readObject();
        this.index = in.readInt();
        this.type = (Class)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.arrayReadAccessor);
        out.writeInt(this.index);
        out.writeObject(this.type);
    }

    @Override
    public void setReadAccessor(InternalReadAccessor readAccessor) {
        this.arrayReadAccessor = readAccessor;
    }

    public InternalReadAccessor getReadAccessor() {
        return this.arrayReadAccessor;
    }

    @Override
    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.type);
    }

    @Override
    public boolean getBooleanValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return (Boolean)array[this.index];
    }

    @Override
    public byte getByteValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return ((Number)array[this.index]).byteValue();
    }

    @Override
    public char getCharValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return ((Character)array[this.index]).charValue();
    }

    @Override
    public double getDoubleValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return ((Number)array[this.index]).doubleValue();
    }

    @Override
    public float getFloatValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return ((Number)array[this.index]).floatValue();
    }

    @Override
    public int getIntValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return ((Number)array[this.index]).intValue();
    }

    @Override
    public long getLongValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return ((Number)array[this.index]).longValue();
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod(this.getNativeReadMethodName(), ReteEvaluator.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        String method = "";
        if (this.type != null && this.type.isPrimitive()) {
            method = StringUtils.ucFirst(this.type.getName());
        }
        return "get" + method + "Value";
    }

    @Override
    public short getShortValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return ((Number)array[this.index]).shortValue();
    }

    @Override
    public Object getValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return array[this.index];
    }

    @Override
    public BigDecimal getBigDecimalValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return MathUtils.getBigDecimal(array[this.index]);
    }

    @Override
    public BigInteger getBigIntegerValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return MathUtils.getBigInteger(array[this.index]);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT_TYPE;
    }

    @Override
    public boolean isNullValue(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        return array[this.index] == null;
    }

    @Override
    public int getHashCode(ReteEvaluator reteEvaluator, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(reteEvaluator, object);
        Object value = array[this.index];
        return value != null ? value.hashCode() : 0;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.arrayReadAccessor == null ? 0 : this.arrayReadAccessor.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayElementReader other = (ArrayElementReader)obj;
        if (this.arrayReadAccessor == null ? other.arrayReadAccessor != null : !this.arrayReadAccessor.equals(other.arrayReadAccessor)) {
            return false;
        }
        return this.index == other.index;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return false;
    }

    @Override
    public boolean getBooleanValue(Object object) {
        return this.getBooleanValue(null, object);
    }

    @Override
    public byte getByteValue(Object object) {
        return this.getByteValue(null, object);
    }

    @Override
    public char getCharValue(Object object) {
        return this.getCharValue(null, object);
    }

    @Override
    public double getDoubleValue(Object object) {
        return this.getDoubleValue(null, object);
    }

    @Override
    public float getFloatValue(Object object) {
        return this.getFloatValue(null, object);
    }

    @Override
    public int getHashCode(Object object) {
        return this.getHashCode(null, object);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getIntValue(Object object) {
        return this.getIntValue(null, object);
    }

    @Override
    public long getLongValue(Object object) {
        return this.getLongValue(null, object);
    }

    @Override
    public short getShortValue(Object object) {
        return this.getShortValue(null, object);
    }

    @Override
    public Object getValue(Object object) {
        return this.getValue(null, object);
    }

    @Override
    public boolean isNullValue(Object object) {
        return this.isNullValue(null, object);
    }

    @Override
    public BigDecimal getBigDecimalValue(Object object) {
        return null;
    }

    @Override
    public BigInteger getBigIntegerValue(Object object) {
        return null;
    }

    @Override
    public void wire(Class<?> klass) {
        this.type = klass;
    }

    @Override
    public String getClassName() {
        return this.type.getName();
    }

    @Override
    public Class<?> getClassType() {
        return this.type;
    }
}

