/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.measurement;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.ScoreUtils;

public class ScoreDifferencePercentage {
    private final double[] percentageLevels;

    public static <Score_ extends Score<Score_>> ScoreDifferencePercentage calculateScoreDifferencePercentage(Score_ baseScore, Score_ valueScore) {
        double[] valueLevels;
        double[] baseLevels = ScoreUtils.extractLevelDoubles(baseScore);
        if (baseLevels.length != (valueLevels = ScoreUtils.extractLevelDoubles(valueScore)).length) {
            throw new IllegalStateException("The baseScore (" + baseScore + ")'s levelsLength (" + baseLevels.length + ") is different from the valueScore (" + valueScore + ")'s levelsLength (" + valueLevels.length + ").");
        }
        double[] percentageLevels = new double[baseLevels.length];
        for (int i = 0; i < baseLevels.length; ++i) {
            percentageLevels[i] = ScoreDifferencePercentage.calculateDifferencePercentage(baseLevels[i], valueLevels[i]);
        }
        return new ScoreDifferencePercentage(percentageLevels);
    }

    public static double calculateDifferencePercentage(double base, double value) {
        double difference = value - base;
        if (base < 0.0) {
            return difference / -base;
        }
        if (base == 0.0) {
            if (difference == 0.0) {
                return 0.0;
            }
            return difference / base;
        }
        return difference / base;
    }

    public ScoreDifferencePercentage(double[] percentageLevels) {
        this.percentageLevels = percentageLevels;
    }

    public double[] getPercentageLevels() {
        return this.percentageLevels;
    }

    public ScoreDifferencePercentage add(ScoreDifferencePercentage addend) {
        if (this.percentageLevels.length != addend.getPercentageLevels().length) {
            throw new IllegalStateException("The addend (" + addend + ")'s levelsLength (" + addend.getPercentageLevels().length + ") is different from the base (" + this + ")'s levelsLength (" + this.percentageLevels.length + ").");
        }
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] + addend.percentageLevels[i];
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public ScoreDifferencePercentage subtract(ScoreDifferencePercentage subtrahend) {
        if (this.percentageLevels.length != subtrahend.getPercentageLevels().length) {
            throw new IllegalStateException("The subtrahend (" + subtrahend + ")'s levelsLength (" + subtrahend.getPercentageLevels().length + ") is different from the base (" + this + ")'s levelsLength (" + this.percentageLevels.length + ").");
        }
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] - subtrahend.percentageLevels[i];
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public ScoreDifferencePercentage multiply(double multiplicand) {
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] * multiplicand;
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public ScoreDifferencePercentage divide(double divisor) {
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] / divisor;
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public String toString() {
        return this.toString(Locale.US);
    }

    public String toString(Locale locale) {
        StringBuilder s = new StringBuilder(this.percentageLevels.length * 8);
        DecimalFormat decimalFormat = new DecimalFormat("0.00%", DecimalFormatSymbols.getInstance(locale));
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            if (i > 0) {
                s.append("/");
            }
            s.append(decimalFormat.format(this.percentageLevels[i]));
        }
        return s.toString();
    }
}

