/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetFilterBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;

public final class BavetFilterBiNode<A, B>
extends BavetAbstractBiNode<A, B> {
    private final BavetAbstractBiNode<A, B> parentNode;
    private final BiPredicate<A, B> predicate;
    private final List<BavetAbstractBiNode<A, B>> childNodeList = new ArrayList<BavetAbstractBiNode<A, B>>();

    public BavetFilterBiNode(BavetConstraintSession session, int nodeIndex, BavetAbstractBiNode<A, B> parentNode, BiPredicate<A, B> predicate) {
        super(session, nodeIndex);
        this.parentNode = parentNode;
        this.predicate = predicate;
    }

    @Override
    public void addChildNode(BavetAbstractBiNode<A, B> childNode) {
        this.childNodeList.add(childNode);
    }

    @Override
    public List<BavetAbstractBiNode<A, B>> getChildNodeList() {
        return this.childNodeList;
    }

    public int hashCode() {
        return Objects.hash(System.identityHashCode(this.parentNode), System.identityHashCode(this.predicate));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFilterBiNode) {
            BavetFilterBiNode other = (BavetFilterBiNode)o;
            return this.parentNode == other.parentNode && this.predicate == other.predicate;
        }
        return false;
    }

    @Override
    public BavetFilterBiTuple<A, B> createTuple(BavetAbstractBiTuple<A, B> parentTuple) {
        return new BavetFilterBiTuple<A, B>(this, parentTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetFilterBiTuple tuple = (BavetFilterBiTuple)uncastTuple;
        Object a = tuple.getFactA();
        Object b = tuple.getFactB();
        List<BavetAbstractTuple> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractTuple bavetAbstractTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive() && this.predicate.test(a, b)) {
            for (BavetAbstractBiNode bavetAbstractBiNode : this.childNodeList) {
                BavetAbstractBiTuple childTuple = bavetAbstractBiNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public String toString() {
        return "Filter() with " + this.childNodeList.size() + " children";
    }
}

