/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.tri;

import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetScoringNode;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriNode;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriTuple;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetScoringTriTuple;
import org.optaplanner.core.impl.score.stream.common.inliner.UndoScoreImpacter;

public final class BavetScoringTriNode<A, B, C>
extends BavetAbstractTriNode<A, B, C>
implements BavetScoringNode {
    private final Score<?> constraintWeight;
    private final TriFunction<A, B, C, UndoScoreImpacter> scoreImpacter;

    public BavetScoringTriNode(BavetConstraintSession session, int nodeIndex, Score<?> constraintWeight, TriFunction<A, B, C, UndoScoreImpacter> scoreImpacter) {
        super(session, nodeIndex);
        this.constraintWeight = constraintWeight;
        this.scoreImpacter = scoreImpacter;
    }

    @Override
    public BavetScoringTriTuple<A, B, C> createTuple(BavetAbstractTriTuple<A, B, C> parentTuple) {
        return new BavetScoringTriTuple<A, B, C>(this, parentTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetScoringTriTuple tuple = (BavetScoringTriTuple)uncastTuple;
        Object a = tuple.getFactA();
        Object b = tuple.getFactB();
        Object c = tuple.getFactC();
        UndoScoreImpacter oldUndoScoreImpacter = tuple.getUndoScoreImpacter();
        if (oldUndoScoreImpacter != null) {
            oldUndoScoreImpacter.run();
        }
        if (tuple.isActive()) {
            UndoScoreImpacter undoScoreImpacter = this.scoreImpacter.apply(a, b, c);
            tuple.setUndoScoreImpacter(undoScoreImpacter);
        } else {
            tuple.setUndoScoreImpacter(null);
        }
    }

    public String toString() {
        return "Scoring(" + this.constraintWeight + ")";
    }
}

