/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Objects;
import java.util.function.BiFunction;
import org.drools.core.util.Drools;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.stream.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.stream.BavetConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.stream.DroolsConstraintStreamScoreDirectorFactory;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;
import org.optaplanner.test.impl.score.stream.DefaultMultiConstraintVerification;
import org.optaplanner.test.impl.score.stream.DefaultSingleConstraintVerification;

public final class DefaultConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, Solution_, Score_ extends Score<Score_>>
implements ConstraintVerifier<ConstraintProvider_, Solution_> {
    private final ConstraintProvider_ constraintProvider;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private ConstraintStreamImplType constraintStreamImplType;
    private Boolean droolsAlphaNetworkCompilationEnabled;

    public DefaultConstraintVerifier(ConstraintProvider_ constraintProvider, SolutionDescriptor<Solution_> solutionDescriptor) {
        this.constraintProvider = constraintProvider;
        this.solutionDescriptor = solutionDescriptor;
    }

    public ConstraintStreamImplType getConstraintStreamImplType() {
        return Objects.requireNonNullElse(this.constraintStreamImplType, ConstraintStreamImplType.DROOLS);
    }

    @Override
    public ConstraintVerifier<ConstraintProvider_, Solution_> withConstraintStreamImplType(ConstraintStreamImplType constraintStreamImplType) {
        Objects.requireNonNull(constraintStreamImplType);
        this.constraintStreamImplType = constraintStreamImplType;
        return this;
    }

    public boolean isDroolsAlphaNetworkCompilationEnabled() {
        return Objects.requireNonNullElse(this.droolsAlphaNetworkCompilationEnabled, !Drools.isNativeImage());
    }

    @Override
    public ConstraintVerifier<ConstraintProvider_, Solution_> withDroolsAlphaNetworkCompilationEnabled(boolean droolsAlphaNetworkCompilationEnabled) {
        this.droolsAlphaNetworkCompilationEnabled = droolsAlphaNetworkCompilationEnabled;
        return this;
    }

    public DefaultSingleConstraintVerification<Solution_, Score_> verifyThat(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
        Objects.requireNonNull(constraintFunction);
        AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.createScoreDirectorFactory(constraintFunction);
        return new DefaultSingleConstraintVerification<Solution_, Score_>(scoreDirectorFactory);
    }

    private AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> createScoreDirectorFactory(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
        ConstraintProvider actualConstraintProvider = constraintFactory -> new Constraint[]{(Constraint)constraintFunction.apply(this.constraintProvider, constraintFactory)};
        return this.createScoreDirectorFactory(actualConstraintProvider);
    }

    private AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> createScoreDirectorFactory(ConstraintProvider constraintProvider) {
        ConstraintStreamImplType constraintStreamImplType_ = this.getConstraintStreamImplType();
        switch (constraintStreamImplType_) {
            case DROOLS: {
                return new DroolsConstraintStreamScoreDirectorFactory(this.solutionDescriptor, constraintProvider, this.isDroolsAlphaNetworkCompilationEnabled());
            }
            case BAVET: {
                if (this.droolsAlphaNetworkCompilationEnabled != null && this.droolsAlphaNetworkCompilationEnabled.booleanValue()) {
                    throw new IllegalArgumentException("Constraint stream implementation (" + constraintStreamImplType_ + ") does not support droolsAlphaNetworkCompilationEnabled (" + this.droolsAlphaNetworkCompilationEnabled + ").");
                }
                return new BavetConstraintStreamScoreDirectorFactory(this.solutionDescriptor, constraintProvider);
            }
        }
        throw new UnsupportedOperationException("Unsupported constraintStreamImplType (" + this.constraintStreamImplType + ").");
    }

    public DefaultMultiConstraintVerification<Solution_, Score_> verifyThat() {
        AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.createScoreDirectorFactory((ConstraintProvider)this.constraintProvider);
        return new DefaultMultiConstraintVerification<Solution_, Score_>(scoreDirectorFactory, (ConstraintProvider)this.constraintProvider);
    }
}

