/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.Collection;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationUtils;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.core.addon.TypeResolver;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.ClassUtils;
import org.drools.drl.ast.descr.AbstractClassTypeDeclarationDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.EnumDeclarationDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.QualifiedName;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.kie.internal.definition.GenericTypeDefinition;

public class TypeDeclarationNameResolver {
    private final KnowledgeBuilderImpl kbuilder;

    public TypeDeclarationNameResolver(KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
    }

    public void resolveTypes(Collection<? extends PackageDescr> packageDescrs, List<TypeDefinition> unresolvedTypes) {
        TypeResolver typeResolver;
        for (PackageDescr packageDescr : packageDescrs) {
            typeResolver = this.kbuilder.getPackageRegistry(packageDescr.getName()).getTypeResolver();
            this.ensureQualifiedDeclarationName(unresolvedTypes, packageDescr, typeResolver);
        }
        for (PackageDescr packageDescr : packageDescrs) {
            typeResolver = this.kbuilder.getPackageRegistry(packageDescr.getName()).getTypeResolver();
            this.qualifyNames(unresolvedTypes, packageDescr, typeResolver);
        }
    }

    public void resolveTypes(PackageDescr packageDescr, List<TypeDefinition> unresolvedTypes, TypeResolver typeResolver) {
        this.ensureQualifiedDeclarationName(unresolvedTypes, packageDescr, typeResolver);
        this.qualifyNames(unresolvedTypes, packageDescr, typeResolver);
    }

    private void ensureQualifiedDeclarationName(List<TypeDefinition> unresolvedTypes, PackageDescr packageDescr, TypeResolver typeResolver) {
        for (AbstractClassTypeDeclarationDescr descr : packageDescr.getClassAndEnumDeclarationDescrs()) {
            this.ensureQualifiedDeclarationName(descr, packageDescr, typeResolver, unresolvedTypes);
        }
    }

    private void qualifyNames(List<TypeDefinition> unresolvedTypes, PackageDescr packageDescr, TypeResolver typeResolver) {
        for (TypeDeclarationDescr declarationDescr : packageDescr.getTypeDeclarations()) {
            this.qualifyNames((AbstractClassTypeDeclarationDescr)declarationDescr, packageDescr, unresolvedTypes, typeResolver);
            this.discoverHierarchyForRedeclarations(declarationDescr, packageDescr, typeResolver);
        }
        for (EnumDeclarationDescr enumDeclarationDescr : packageDescr.getEnumDeclarations()) {
            this.qualifyNames((AbstractClassTypeDeclarationDescr)enumDeclarationDescr, packageDescr, unresolvedTypes, typeResolver);
        }
    }

    private void qualifyNames(AbstractClassTypeDeclarationDescr declarationDescr, PackageDescr packageDescr, List<TypeDefinition> unresolvedTypes, TypeResolver typeResolver) {
        this.ensureQualifiedSuperType(declarationDescr, packageDescr, typeResolver, unresolvedTypes);
        this.ensureQualifiedFieldType(declarationDescr, packageDescr, typeResolver, unresolvedTypes);
    }

    private void discoverHierarchyForRedeclarations(TypeDeclarationDescr typeDescr, PackageDescr packageDescr, TypeResolver typeResolver) {
        PackageRegistry pkReg = this.kbuilder.getPackageRegistry(packageDescr.getName());
        Class<?> typeClass = TypeDeclarationUtils.getExistingDeclarationClass((AbstractClassTypeDeclarationDescr)typeDescr, pkReg);
        if (typeClass != null) {
            if (typeDescr.isTrait()) {
                this.fillStaticInterfaces(typeDescr, typeClass);
            } else {
                typeDescr.getSuperTypes().clear();
                typeDescr.addSuperType(typeClass.isInterface() || typeClass == Object.class ? Object.class.getName() : typeClass.getSuperclass().getName());
            }
        } else {
            typeResolver.registerClass(typeDescr.getFullTypeName(), null);
        }
    }

    private void ensureQualifiedDeclarationName(AbstractClassTypeDeclarationDescr declarationDescr, PackageDescr packageDescr, TypeResolver typeResolver, List<TypeDefinition> unresolvedTypes) {
        String resolvedName = this.resolveName(declarationDescr.getType().getFullName(), declarationDescr, packageDescr, typeResolver, unresolvedTypes, false);
        if (!declarationDescr.getType().getFullName().equals(resolvedName) || !declarationDescr.getType().isFullyQualified()) {
            if (resolvedName != null && !this.alreadyDefinedInPackage(resolvedName, declarationDescr, packageDescr)) {
                declarationDescr.setTypeName(resolvedName);
            } else {
                declarationDescr.setNamespace(packageDescr.getNamespace());
            }
        }
    }

    private boolean alreadyDefinedInPackage(String resolved, AbstractClassTypeDeclarationDescr current, PackageDescr pd) {
        for (AbstractClassTypeDeclarationDescr typeDeclaration : pd.getClassAndEnumDeclarationDescrs()) {
            if (typeDeclaration == current || !typeDeclaration.getType().getFullName().equals(resolved)) continue;
            return true;
        }
        return false;
    }

    private void ensureQualifiedSuperType(AbstractClassTypeDeclarationDescr typeDescr, PackageDescr packageDescr, TypeResolver typeResolver, List<TypeDefinition> unresolvedTypes) {
        for (QualifiedName qname : typeDescr.getSuperTypes()) {
            String declaredSuperType = qname.getFullName();
            String resolved = this.resolveName(declaredSuperType, typeDescr, packageDescr, typeResolver, unresolvedTypes, true);
            if (resolved != null) {
                qname.setName(resolved);
                continue;
            }
            this.kbuilder.addBuilderResult(new TypeDeclarationError((BaseDescr)typeDescr, "Cannot resolve supertype '" + declaredSuperType + " for declared type " + typeDescr.getTypeName()));
        }
    }

    public void ensureQualifiedFieldType(AbstractClassTypeDeclarationDescr typeDescr, PackageDescr packageDescr, TypeResolver typeResolver, List<TypeDefinition> unresolvedTypes) {
        for (TypeFieldDescr field : typeDescr.getFields().values()) {
            GenericTypeDefinition typeDef = GenericTypeDefinition.parseType((String)field.getPattern().getObjectType(), type -> this.resolveName((String)type, typeDescr, packageDescr, typeResolver, unresolvedTypes, true));
            if (typeDef == null) {
                this.kbuilder.addBuilderResult(new TypeDeclarationError((BaseDescr)typeDescr, "Cannot resolve type '" + field.getPattern().getObjectType() + " for field " + field.getFieldName() + " in declared type " + typeDescr.getTypeName()));
                continue;
            }
            field.getPattern().setGenericType(typeDef);
        }
    }

    private String resolveName(String type, AbstractClassTypeDeclarationDescr typeDescr, PackageDescr packageDescr, TypeResolver typeResolver, List<TypeDefinition> unresolvedTypes, boolean forceResolution) {
        boolean qualified = TypeDeclarationUtils.isQualified(type);
        if (!qualified) {
            type = TypeDeclarationUtils.lookupSimpleNameByImports(type, typeDescr, packageDescr, this.kbuilder.getRootClassLoader());
        }
        if (!(qualified = TypeDeclarationUtils.isQualified(type = TypeDeclarationUtils.resolveType(type, packageDescr, this.kbuilder.getPackageRegistry(packageDescr.getNamespace()))))) {
            try {
                Class klass = typeResolver.resolveType(type, (TypeResolver.ClassFilter)TypeResolver.EXCLUDE_ANNOTATION_CLASS_FILTER);
                type = klass.getCanonicalName();
                return type;
            }
            catch (ClassNotFoundException klass) {}
        } else {
            type = TypeDeclarationUtils.typeName2ClassName(type, this.kbuilder.getRootClassLoader());
            qualified = TypeDeclarationUtils.isQualified(type);
        }
        if (forceResolution && !qualified) {
            TypeDeclaration temp = new TypeDeclaration(type);
            temp.setTypeClassName(type);
            unresolvedTypes.add(new TypeDefinition(temp, null));
        }
        return qualified ? type : null;
    }

    private void fillStaticInterfaces(TypeDeclarationDescr typeDescr, Class<?> typeClass) {
        for (Class iKlass : ClassUtils.getMinimalImplementedInterfaceNames(typeClass)) {
            typeDescr.addSuperType(iKlass.getName());
        }
    }
}

