/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.compiler.compiler.DroolsError;
import org.drools.drl.ast.descr.FunctionDescr;
import org.kie.internal.jci.CompilationProblem;

public class FunctionError
extends DroolsError {
    private final FunctionDescr functionDescr;
    private final Object object;
    private final String message;
    private int[] errorLines;

    public FunctionError(FunctionDescr functionDescr, Object object, String message) {
        super(functionDescr.getResource());
        this.functionDescr = functionDescr;
        this.object = object;
        this.message = this.createMessage(message);
    }

    @Override
    public String getNamespace() {
        return this.functionDescr.getNamespace();
    }

    public FunctionDescr getFunctionDescr() {
        return this.functionDescr;
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public int[] getLines() {
        return this.errorLines;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return this.message;
    }

    private String createMessage(String message) {
        StringBuilder detail = new StringBuilder();
        if (this.object instanceof CompilationProblem[]) {
            CompilationProblem[] cp = (CompilationProblem[])this.object;
            this.errorLines = new int[cp.length];
            for (int i = 0; i < cp.length; ++i) {
                this.errorLines[i] = cp[i].getStartLine() - this.functionDescr.getOffset() + this.getFunctionDescr().getLine() - 1;
                detail.append(this.functionDescr.getName());
                detail.append(" (line:");
                detail.append(this.errorLines[i]);
                detail.append("): ");
                detail.append(cp[i].getMessage());
                detail.append("\n");
            }
        } else if (this.object instanceof Exception) {
            Exception ex = (Exception)this.object;
            this.errorLines = new int[1];
            this.errorLines[0] = this.functionDescr.getLine();
            detail.append(" (line:");
            detail.append(this.errorLines[0]);
            detail.append("): ");
            detail.append(message);
            detail.append(" ");
            detail.append(ex.getClass().getName());
            if (ex.getMessage() != null) {
                detail.append(": ");
                detail.append(ex.getMessage());
            }
        } else {
            this.errorLines = new int[1];
            this.errorLines[0] = this.functionDescr.getLine();
        }
        return "[ function " + this.functionDescr.getName() + detail.toString() + " ]";
    }
}

