/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.core.util.StringUtils;
import org.drools.drl.ast.descr.AccumulateDescr;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.BindingDescr;
import org.drools.drl.ast.descr.CollectDescr;
import org.drools.drl.ast.descr.EvalDescr;
import org.drools.drl.ast.descr.ExistsDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.ForallDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.FunctionImportDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.LiteralRestrictionDescr;
import org.drools.drl.ast.descr.NotDescr;
import org.drools.drl.ast.descr.OrDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.PackageDescrDumper;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.PredicateDescr;
import org.drools.drl.ast.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.drl.ast.descr.QueryDescr;
import org.drools.drl.ast.descr.ReturnValueRestrictionDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.ast.descr.VariableRestrictionDescr;

public class XmlDumper
extends ReflectiveVisitor
implements PackageDescrDumper {
    private StringBuilder xmlDump;
    private boolean patternContext;
    private static final String eol = System.getProperty("line.separator");
    private String template;

    public synchronized String dump(PackageDescr packageDescr) {
        this.xmlDump = new StringBuilder();
        this.visitPackageDescr(packageDescr);
        return this.xmlDump.toString();
    }

    public void visitAndDescr(AndDescr descr) {
        this.template = new String();
        if (descr.getDescrs() != Collections.EMPTY_LIST) {
            this.template = !this.patternContext ? "<and-conditional-element>" + this.processDescrList(descr.getDescrs()) + "</and-conditional-element>" : "<and-constraint-connective>" + this.processDescrList(descr.getDescrs()) + "</and-constraint-connective>";
        }
    }

    public void visitAttributeDescr(AttributeDescr attributeDescr) {
        this.template = new String();
        this.template = "<rule-attribute name=\"" + attributeDescr.getName() + "\" value=\"" + attributeDescr.getValue() + "\" />" + eol;
    }

    public void visitVariableRestrictionDescr(VariableRestrictionDescr descr) {
        this.template = new String();
        this.template = "<variable-restriction evaluator=\"" + XmlDumper.replaceIllegalChars(descr.getEvaluator()) + "\" identifier=\"" + descr.getIdentifier() + "\" />" + eol;
    }

    public void visitPatternDescr(PatternDescr descr) {
        this.patternContext = true;
        this.template = new String();
        StringBuilder localString = new StringBuilder();
        if (descr.getDescrs() != Collections.EMPTY_LIST) {
            if (descr.getIdentifier() != null) {
                localString.append("<pattern identifier=\"" + descr.getIdentifier() + "\" object-type=\"" + descr.getObjectType() + "\" >" + eol + this.processDescrList(descr.getDescrs()) + eol);
            } else {
                localString.append("<pattern object-type=\"" + descr.getObjectType() + "\" >" + eol + this.processDescrList(descr.getDescrs()) + eol);
            }
        } else if (descr.getIdentifier() != null) {
            localString.append("<pattern identifier=\"" + descr.getIdentifier() + "\" object-type=\"" + descr.getObjectType() + "\" >" + eol);
        } else {
            localString.append("<pattern object-type=\"" + descr.getObjectType() + "\" >" + eol);
        }
        if (descr.getSource() != null) {
            this.visit(descr.getSource());
            localString.append(this.template);
        }
        localString.append("</pattern>" + eol);
        this.template = localString.toString();
        this.patternContext = false;
    }

    public void visitExprConstraintDescr(ExprConstraintDescr descr) {
        this.template = "<expr>" + eol + StringUtils.escapeXmlString((String)descr.getExpression()) + eol + "</expr>";
    }

    public void visitCollectDescr(CollectDescr descr) {
        StringBuilder tmpstr = new StringBuilder();
        tmpstr.append("<from> <collect>");
        this.visit(descr.getInputPattern());
        tmpstr.append(this.template);
        tmpstr.append(" </collect> </from> ");
        this.template = tmpstr.toString();
    }

    public void visitAccumulateDescr(AccumulateDescr descr) {
        String tmpstr = new String();
        tmpstr = tmpstr + this.template + " <from> <accumulate> ";
        if (descr.isSinglePattern()) {
            this.visitPatternDescr(descr.getInputPattern());
        } else {
            this.patternContext = false;
            this.visit(descr.getInput());
        }
        tmpstr = tmpstr + this.template;
        if (descr.isExternalFunction()) {
            AccumulateDescr.AccumulateFunctionCallDescr func = (AccumulateDescr.AccumulateFunctionCallDescr)descr.getFunctions().get(0);
            tmpstr = tmpstr + "<external-function evaluator=\"" + func.getFunction() + "\" expression=\"" + func.getParams()[0] + "\"/>";
        } else {
            tmpstr = tmpstr + "<init>" + descr.getInitCode() + "</init><action>" + descr.getActionCode() + "</action><result>" + descr.getResultCode() + "</result>";
        }
        this.template = tmpstr + " </accumulate> </from> ";
    }

    public void visitFromDescr(FromDescr descr) {
        String tmpstr = new String();
        tmpstr = tmpstr + this.template + " <from> <expression> ";
        tmpstr = tmpstr + descr.getDataSource();
        this.template = tmpstr + " </expression> </from> ";
    }

    public void visitForallDescr(ForallDescr descr) {
        this.template = "<forall>" + this.processDescrList(descr.getDescrs()) + "</forall>";
    }

    public void visitEvalDescr(EvalDescr descr) {
        this.template = new String();
        this.template = "<eval>" + XmlDumper.replaceIllegalChars((String)descr.getContent()) + "</eval>" + eol;
    }

    public void visitExistsDescr(ExistsDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? "<exists>" + this.processDescrList(descr.getDescrs()) + "</exists>" : "<exists> </exists>";
    }

    public void visitBindingDescr(BindingDescr descr) {
        this.template = new String();
        this.template = "<field-binding field-name=\"" + descr.getExpression() + "\" identifier=\"" + descr.getVariable() + "\" />" + eol;
    }

    public void visitFunctionDescr(FunctionDescr functionDescr) {
        this.template = new String();
        String parameterTemplate = this.processParameters(functionDescr.getParameterNames(), functionDescr.getParameterTypes());
        this.template = "<function return-type=\"" + functionDescr.getReturnType() + "\" name=\"" + functionDescr.getName() + "\">" + eol + parameterTemplate + "<body>" + eol + XmlDumper.replaceIllegalChars(functionDescr.getText()) + eol + "</body>" + eol + "</function>" + eol;
    }

    public void visitLiteralRestrictionDescr(LiteralRestrictionDescr descr) {
        this.template = new String();
        this.template = "<literal-restriction evaluator=\"" + XmlDumper.replaceIllegalChars(descr.getEvaluator()) + "\" value=\"" + XmlDumper.replaceIllegalChars(descr.getText()) + "\" />" + eol;
    }

    public void visitQualifiedIdentifierRestrictionDescr(QualifiedIdentifierRestrictionDescr descr) {
        this.template = new String();
        this.template = "<qualified-identifier-restriction evaluator=\"" + XmlDumper.replaceIllegalChars(descr.getEvaluator()) + "\">" + XmlDumper.replaceIllegalChars(descr.getText()) + " </qualified-identifier-restriction>" + eol;
    }

    public void visitNotDescr(NotDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? "<not>" + this.processDescrList(descr.getDescrs()) + "</not>" : "<not> </not>";
    }

    public void visitOrDescr(OrDescr descr) {
        this.template = new String();
        if (descr.getDescrs() != Collections.EMPTY_LIST) {
            this.template = !this.patternContext ? "<or-conditional-element>" + this.processDescrList(descr.getDescrs()) + "</or-conditional-element>" : "<or-constraint-connective>" + this.processDescrList(descr.getDescrs()) + "</or-constraint-connective>";
        }
    }

    public void visitPackageDescr(PackageDescr packageDescr) {
        String packageName = packageDescr.getName();
        String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> " + eol + " <package name=\"" + packageName + "\"  " + eol + "\txmlns=\"http://drools.org/drools-5.2\" " + eol + "\txmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" " + eol + "\txs:schemaLocation=\"http://drools.org/drools-5.2 drools.org/drools-5.2.xsd\"> " + eol;
        this.appendXmlDump(xmlString);
        this.appendXmlDump(this.processImportsList(packageDescr.getImports()));
        this.appendXmlDump(this.processGlobalsList(packageDescr.getGlobals()));
        this.appendXmlDump(this.processFunctionImportsList(packageDescr.getFunctionImports()));
        this.appendXmlDump(this.processFunctionsList(packageDescr.getFunctions()));
        this.appendXmlDump(this.processRules(packageDescr.getRules()));
        this.appendXmlDump("</package>");
    }

    public void visitPredicateDescr(PredicateDescr descr) {
        this.template = new String();
        this.template = "<predicate>" + XmlDumper.replaceIllegalChars((String)descr.getContent()) + "</predicate>" + eol;
    }

    public void visitReturnValueRestrictionDescr(ReturnValueRestrictionDescr descr) {
        this.template = new String();
        this.template = "<return-value-restriction evaluator=\"" + XmlDumper.replaceIllegalChars(descr.getEvaluator()) + "\" >" + XmlDumper.replaceIllegalChars((String)descr.getContent()) + "</return-value-restriction>" + eol;
    }

    public void visitQueryDescr(QueryDescr descr) {
        this.template = new String();
        this.template = "<query name=\"" + descr.getName() + "\"><lhs>" + this.processDescrList(descr.getLhs().getDescrs()) + "</lhs></query>";
    }

    private String processRules(List rules) {
        String ruleList = "";
        for (RuleDescr ruleDescr : rules) {
            String rule = "<rule name=\"" + ruleDescr.getName() + "\">" + eol;
            String attribute = this.processAttribute(ruleDescr.getAttributes().values());
            String lhs = "";
            lhs = ruleDescr.getLhs().getDescrs() != Collections.EMPTY_LIST ? "<lhs>" + this.processDescrList(ruleDescr.getLhs().getDescrs()) + "</lhs>" : "<lhs> </lhs>";
            String rhs = "<rhs>" + XmlDumper.replaceIllegalChars((String)ruleDescr.getConsequence()) + "</rhs>" + eol;
            rule = rule + attribute;
            rule = rule + lhs;
            rule = rule + rhs;
            rule = rule + "</rule>";
            ruleList = ruleList + rule;
        }
        return ruleList + eol;
    }

    private String processDescrList(List descr) {
        String descrString = "";
        Iterator iterator = descr.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            descrString = descrString + this.template;
            descrString = descrString + eol;
        }
        return descrString + eol;
    }

    private String processFunctionsList(List functions) {
        String functionList = "";
        Iterator iterator = functions.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            functionList = functionList + this.template;
        }
        return functionList + eol;
    }

    private String processAttribute(Collection<AttributeDescr> attributes) {
        String attributeList = "";
        for (AttributeDescr attributeDescr : attributes) {
            this.visit(attributeDescr);
            attributeList = attributeList + this.template;
        }
        return attributeList + eol;
    }

    private String processParameters(List parameterNames, List parameterTypes) {
        String paramList = "";
        int i = 0;
        for (String paramName : parameterNames) {
            String paramType = (String)parameterTypes.get(i);
            String paramTemplate = "<parameter identifier=\"" + paramName + "\" type=\"" + paramType + "\" />" + eol;
            paramList = paramList + paramTemplate;
            ++i;
        }
        return paramList + eol;
    }

    private String processFunctionImportsList(List imports) {
        String importList = "";
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String importString = ((FunctionImportDescr)it.next()).getTarget();
            String importTemplate = "<importfunction name=\"" + importString + "\"/>" + eol;
            importList = importList + importTemplate;
        }
        return importList + eol;
    }

    private String processGlobalsList(List globals) {
        String globalList = "";
        for (GlobalDescr global : globals) {
            String identifier = global.getIdentifier();
            String type = global.getType();
            String globalTemplate = "<global identifier=\"" + identifier + "\" type=\"" + type + "\" />" + eol;
            globalList = globalList + globalTemplate;
        }
        return globalList + eol;
    }

    private String processImportsList(List imports) {
        String importList = "";
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String importString = ((ImportDescr)iterator.next()).getTarget();
            String importTemplate = "<import name=\"" + importString + "\" /> " + eol;
            importList = importList + importTemplate;
        }
        return importList + eol;
    }

    private void appendXmlDump(String temp) {
        this.xmlDump.append(temp);
    }

    public static String replaceIllegalChars(String code) {
        StringBuilder sb = new StringBuilder();
        if (code != null) {
            int n = code.length();
            block5: for (int i = 0; i < n; ++i) {
                char c = code.charAt(i);
                switch (c) {
                    case '<': {
                        sb.append("&lt;");
                        continue block5;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block5;
                    }
                    case '&': {
                        sb.append("&amp;");
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

