/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.common.inliner;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.buildin.BendableBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.BendableLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.BendableScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardMediumSoftBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardMediumSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardMediumSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardSoftBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.SimpleBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.SimpleLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.constraint.DefaultConstraintMatchTotal;
import org.optaplanner.core.impl.score.constraint.DefaultIndictment;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.stream.common.inliner.BendableBigDecimalScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.BendableLongScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.BendableScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.HardMediumSoftBigDecimalScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.HardMediumSoftLongScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.HardMediumSoftScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.HardSoftBigDecimalScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.HardSoftLongScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.HardSoftScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.SimpleBigDecimalScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.SimpleLongScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.SimpleScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.WeightedScoreImpacter;

public abstract class AbstractScoreInliner<Score_ extends Score<Score_>> {
    @Deprecated(forRemoval=true)
    private static final String CUSTOM_SCORE_INLINER_CLASS_PROPERTY_NAME = "org.optaplanner.score.stream.inliner";
    private final Map<String, Score_> constraintIdToWeightMap;
    protected final boolean constraintMatchEnabled;
    private final Map<String, DefaultConstraintMatchTotal<Score_>> constraintMatchTotalMap;
    private final Map<Object, DefaultIndictment<Score_>> indictmentMap;

    public static <Score_ extends Score<Score_>, ScoreInliner_ extends AbstractScoreInliner<Score_>> ScoreInliner_ buildScoreInliner(ScoreDefinition<Score_> scoreDefinition, Map<Constraint, Score_> constraintIdToWeightMap, boolean constraintMatchEnabled) {
        if (scoreDefinition instanceof SimpleScoreDefinition) {
            return (ScoreInliner_)new SimpleScoreInliner(constraintIdToWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof SimpleLongScoreDefinition) {
            return (ScoreInliner_)new SimpleLongScoreInliner((Map<Constraint, SimpleLongScore>)constraintIdToWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof SimpleBigDecimalScoreDefinition) {
            return (ScoreInliner_)new SimpleBigDecimalScoreInliner((Map<Constraint, SimpleBigDecimalScore>)constraintIdToWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardSoftScoreDefinition) {
            return (ScoreInliner_)new HardSoftScoreInliner((Map<Constraint, HardSoftScore>)constraintIdToWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardSoftLongScoreDefinition) {
            return (ScoreInliner_)new HardSoftLongScoreInliner((Map<Constraint, HardSoftLongScore>)constraintIdToWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardSoftBigDecimalScoreDefinition) {
            return (ScoreInliner_)new HardSoftBigDecimalScoreInliner((Map<Constraint, HardSoftBigDecimalScore>)constraintIdToWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardMediumSoftScoreDefinition) {
            return (ScoreInliner_)new HardMediumSoftScoreInliner((Map<Constraint, HardMediumSoftScore>)constraintIdToWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardMediumSoftLongScoreDefinition) {
            return (ScoreInliner_)new HardMediumSoftLongScoreInliner((Map<Constraint, HardMediumSoftLongScore>)constraintIdToWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardMediumSoftBigDecimalScoreDefinition) {
            return (ScoreInliner_)new HardMediumSoftBigDecimalScoreInliner((Map<Constraint, HardMediumSoftBigDecimalScore>)constraintIdToWeightMap, constraintMatchEnabled);
        }
        if (scoreDefinition instanceof BendableScoreDefinition) {
            BendableScoreDefinition bendableScoreDefinition = (BendableScoreDefinition)scoreDefinition;
            return (ScoreInliner_)new BendableScoreInliner(constraintIdToWeightMap, constraintMatchEnabled, bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize());
        }
        if (scoreDefinition instanceof BendableLongScoreDefinition) {
            BendableLongScoreDefinition bendableScoreDefinition = (BendableLongScoreDefinition)scoreDefinition;
            return (ScoreInliner_)new BendableLongScoreInliner(constraintIdToWeightMap, constraintMatchEnabled, bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize());
        }
        if (scoreDefinition instanceof BendableBigDecimalScoreDefinition) {
            BendableBigDecimalScoreDefinition bendableScoreDefinition = (BendableBigDecimalScoreDefinition)scoreDefinition;
            return (ScoreInliner_)new BendableBigDecimalScoreInliner(constraintIdToWeightMap, constraintMatchEnabled, bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize());
        }
        String customScoreInlinerClassName = System.getProperty(CUSTOM_SCORE_INLINER_CLASS_PROPERTY_NAME);
        if (customScoreInlinerClassName == null) {
            throw new UnsupportedOperationException("Unknown score definition class (" + scoreDefinition.getClass().getCanonicalName() + ").\nIf you're attempting to use a custom score, provide your " + AbstractScoreInliner.class.getSimpleName() + " implementation using the 'org.optaplanner.score.stream.inliner' system property.\nNote: support for custom scores will be removed in OptaPlanner 9.0.");
        }
        try {
            Class<?> customScoreInlinerClass = Class.forName(customScoreInlinerClassName);
            if (!AbstractScoreInliner.class.isAssignableFrom(customScoreInlinerClass)) {
                throw new IllegalStateException("Custom score inliner class (" + customScoreInlinerClassName + ") does not extend " + AbstractScoreInliner.class.getCanonicalName() + ".\nNote: support for custom scores will be removed in OptaPlanner 9.0.");
            }
            return (ScoreInliner_)((AbstractScoreInliner)customScoreInlinerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cause) {
            throw new IllegalStateException("Custom score inliner class (" + customScoreInlinerClassName + ") can not be instantiated.\nMaybe add a no-arg public constructor?\nNote: support for custom scores will be removed in OptaPlanner 9.0.", cause);
        }
    }

    protected AbstractScoreInliner(Map<Constraint, Score_> constraintToWeightMap, boolean constraintMatchEnabled) {
        this.constraintIdToWeightMap = Objects.requireNonNull(constraintToWeightMap).entrySet().stream().collect(Collectors.toMap(e -> ((Constraint)e.getKey()).getConstraintId(), Map.Entry::getValue));
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.constraintMatchTotalMap = constraintMatchEnabled ? new LinkedHashMap() : null;
        this.indictmentMap = constraintMatchEnabled ? new LinkedHashMap() : null;
    }

    public abstract Score_ extractScore(int var1);

    public abstract WeightedScoreImpacter buildWeightedScoreImpacter(Constraint var1);

    protected final Runnable addConstraintMatch(Constraint constraint, Score_ constraintWeight, Score_ score, List<Object> justificationList) {
        String constraintPackage = constraint.getConstraintPackage();
        String constraintName = constraint.getConstraintName();
        DefaultConstraintMatchTotal constraintMatchTotal = this.constraintMatchTotalMap.computeIfAbsent(constraint.getConstraintId(), key -> new DefaultConstraintMatchTotal<Score>(constraintPackage, constraintName, (Score)constraintWeight));
        ConstraintMatch constraintMatch = constraintMatchTotal.addConstraintMatch(justificationList, score);
        DefaultIndictment[] indictments = (DefaultIndictment[])justificationList.stream().distinct().map(justification -> {
            DefaultIndictment indictment = this.indictmentMap.computeIfAbsent(justification, key -> new DefaultIndictment(justification, constraintMatch.getScore().zero()));
            indictment.addConstraintMatch(constraintMatch);
            return indictment;
        }).toArray(DefaultIndictment[]::new);
        return () -> {
            constraintMatchTotal.removeConstraintMatch(constraintMatch);
            if (constraintMatchTotal.getConstraintMatchSet().isEmpty()) {
                this.constraintMatchTotalMap.remove(constraint.getConstraintId());
            }
            for (DefaultIndictment indictment : indictments) {
                indictment.removeConstraintMatch(constraintMatch);
                if (!indictment.getConstraintMatchSet().isEmpty()) continue;
                this.indictmentMap.remove(indictment.getJustification());
            }
        };
    }

    public final Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        return this.constraintMatchTotalMap;
    }

    public final Map<Object, Indictment<Score_>> getIndictmentMap() {
        return this.indictmentMap;
    }

    protected final Score_ getConstraintWeight(Constraint constraint) {
        Score constraintWeight = (Score)this.constraintIdToWeightMap.get(constraint.getConstraintId());
        if (constraintWeight == null || constraintWeight.isZero()) {
            throw new IllegalArgumentException("Impossible state: The constraintWeight (" + constraintWeight + ") cannot be zero, constraint (" + constraint + ") should have been culled during node creation.");
        }
        return (Score_)constraintWeight;
    }
}

