/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.common.inliner;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.impl.score.stream.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.stream.common.inliner.WeightedScoreImpacter;

final class BendableBigDecimalScoreInliner
extends AbstractScoreInliner<BendableBigDecimalScore> {
    private final BigDecimal[] hardScores;
    private final BigDecimal[] softScores;

    BendableBigDecimalScoreInliner(Map<Constraint, BendableBigDecimalScore> constraintToWeightMap, boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintToWeightMap, constraintMatchEnabled);
        this.hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(this.hardScores, BigDecimal.ZERO);
        this.softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(this.softScores, BigDecimal.ZERO);
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        Integer singleLevel = null;
        BendableBigDecimalScore constraintWeight = (BendableBigDecimalScore)this.getConstraintWeight(constraint);
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if (constraintWeight.getHardOrSoftScore(i).equals(BigDecimal.ZERO)) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            BigDecimal levelWeight = constraintWeight.getHardOrSoftScore(singleLevel);
            if (singleLevel < constraintWeight.getHardLevelsSize()) {
                int level = singleLevel;
                return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                    BigDecimal hardImpact = levelWeight.multiply(matchWeight);
                    this.hardScores[level] = this.hardScores[level].add(hardImpact);
                    UndoScoreImpacter undoScoreImpact = () -> {
                        this.hardScores[level] = this.hardScores[level].subtract(hardImpact);
                    };
                    if (!this.constraintMatchEnabled) {
                        return undoScoreImpact;
                    }
                    Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableBigDecimalScore.ofHard(this.hardScores.length, this.softScores.length, level, hardImpact), (List)justificationsSupplier.get());
                    return () -> {
                        undoScoreImpact.run();
                        undoConstraintMatch.run();
                    };
                });
            }
            int level = singleLevel - constraintWeight.getHardLevelsSize();
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                BigDecimal softImpact = levelWeight.multiply(matchWeight);
                this.softScores[level] = this.softScores[level].add(softImpact);
                UndoScoreImpacter undoScoreImpact = () -> {
                    this.softScores[level] = this.softScores[level].subtract(softImpact);
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableBigDecimalScore.ofSoft(this.hardScores.length, this.softScores.length, level, softImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            int i;
            BigDecimal[] hardImpacts = new BigDecimal[this.hardScores.length];
            BigDecimal[] softImpacts = new BigDecimal[this.softScores.length];
            for (i = 0; i < hardImpacts.length; ++i) {
                hardImpacts[i] = constraintWeight.getHardScore(i).multiply(matchWeight);
                this.hardScores[i] = this.hardScores[i].add(hardImpacts[i]);
            }
            for (i = 0; i < softImpacts.length; ++i) {
                softImpacts[i] = constraintWeight.getSoftScore(i).multiply(matchWeight);
                this.softScores[i] = this.softScores[i].add(softImpacts[i]);
            }
            UndoScoreImpacter undoScoreImpact = () -> {
                int i;
                for (i = 0; i < hardImpacts.length; ++i) {
                    this.hardScores[i] = this.hardScores[i].subtract(hardImpacts[i]);
                }
                for (i = 0; i < softImpacts.length; ++i) {
                    this.softScores[i] = this.softScores[i].subtract(softImpacts[i]);
                }
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableBigDecimalScore.of(hardImpacts, softImpacts), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public BendableBigDecimalScore extractScore(int initScore) {
        return BendableBigDecimalScore.ofUninitialized(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

