/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Collection;
import java.util.List;
import org.drools.core.base.ClassObjectType;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.AllSetButLastBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;
import org.drools.core.util.bitmask.EmptyButLastBitMask;

public class PropertySpecificUtil {
    public static final int TRAITABLE_BIT = 0;
    public static final int CUSTOM_BITS_OFFSET = 1;

    public static boolean isPropertyReactive(BuildContext context, ObjectType objectType) {
        return objectType instanceof ClassObjectType && PropertySpecificUtil.isPropertyReactive(context, ((ClassObjectType)objectType).getClassType());
    }

    public static boolean isPropertyReactive(BuildContext context, Class<?> objectClass) {
        TypeDeclaration typeDeclaration = context.getRuleBase().getTypeDeclaration(objectClass);
        return typeDeclaration != null && typeDeclaration.isPropertyReactive();
    }

    public static BitMask getEmptyPropertyReactiveMask(int settablePropertiesSize) {
        return BitMask.Factory.getEmpty(settablePropertiesSize + 1);
    }

    public static BitMask onlyTraitBitSetMask() {
        return EmptyButLastBitMask.get();
    }

    public static BitMask allSetBitMask() {
        return AllSetBitMask.get();
    }

    public static BitMask allSetButTraitBitMask() {
        return AllSetButLastBitMask.get();
    }

    public static boolean isAllSetPropertyReactiveMask(BitMask mask) {
        return mask instanceof AllSetButLastBitMask;
    }

    public static BitMask calculatePositiveMask(Class modifiedClass, Collection<String> listenedProperties, List<String> accessibleProperties) {
        return PropertySpecificUtil.calculatePatternMask(modifiedClass, listenedProperties, accessibleProperties, true);
    }

    public static BitMask calculateNegativeMask(Class modifiedClass, Collection<String> listenedProperties, List<String> accessibleProperties) {
        return PropertySpecificUtil.calculatePatternMask(modifiedClass, listenedProperties, accessibleProperties, false);
    }

    private static BitMask calculatePatternMask(Class modifiedClass, Collection<String> listenedProperties, List<String> accessibleProperties, boolean isPositive) {
        if (listenedProperties.isEmpty()) {
            return EmptyBitMask.get();
        }
        BitMask mask = PropertySpecificUtil.getEmptyPropertyReactiveMask(accessibleProperties.size());
        if (listenedProperties.contains("__$$dynamic_traits_map$$") && isPositive && listenedProperties.contains("__$$dynamic_traits_map$$")) {
            mask = mask.set(0);
        }
        for (String propertyName : listenedProperties) {
            if (propertyName.equals(isPositive ? "*" : "!*")) {
                return isPositive ? AllSetBitMask.get() : PropertySpecificUtil.allSetButTraitBitMask();
            }
            if (propertyName.startsWith("!") ^ !isPositive) continue;
            if (!isPositive) {
                propertyName = propertyName.substring(1);
            }
            mask = PropertySpecificUtil.setPropertyOnMask(modifiedClass, mask, accessibleProperties, propertyName);
        }
        return mask;
    }

    public static BitMask setPropertyOnMask(Class modifiedClass, BitMask mask, List<String> settableProperties, String propertyName) {
        int index = settableProperties.indexOf(propertyName);
        if (index < 0) {
            throw new RuntimeException("Unknown property '" + propertyName + "' on " + modifiedClass);
        }
        return PropertySpecificUtil.setPropertyOnMask(mask, index);
    }

    public static BitMask setPropertyOnMask(BitMask mask, int index) {
        return mask.set(index + 1);
    }

    public static boolean isPropertySetOnMask(BitMask mask, int index) {
        return mask.isSet(index + 1);
    }

    public static List<String> getAccessibleProperties(RuleBase ruleBase, Class<?> nodeClass) {
        return ruleBase.getOrCreateExactTypeDeclaration(nodeClass).getAccessibleProperties();
    }
}

