/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Comparator;
import java.util.Map;
import org.drools.core.base.SalienceInteger;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.AgendaComponentFactory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.kie.api.definition.rule.Rule;

public class RuleTerminalNode
extends AbstractTerminalNode {
    private static final long serialVersionUID = 510L;
    protected RuleImpl rule;
    protected GroupElement subrule;
    protected int subruleIndex;
    protected Declaration[] allDeclarations;
    protected Declaration[] requiredDeclarations;
    protected Declaration[] salienceDeclarations;
    protected Declaration[] enabledDeclarations;
    protected LeftTupleSinkNode previousTupleSinkNode;
    protected LeftTupleSinkNode nextTupleSinkNode;
    protected boolean fireDirect;
    protected transient ObjectTypeNode.Id leftInputOtnId;
    protected String consequenceName;

    public RuleTerminalNode() {
    }

    public RuleTerminalNode(int id, LeftTupleSource source, RuleImpl rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), source, context);
        this.rule = rule;
        this.subrule = subrule;
        this.consequenceName = context.getConsequenceName();
        this.initDeclarations();
        this.subruleIndex = subruleIndex;
        this.setFireDirect(rule.getActivationListener().equals("direct"));
        if (this.isFireDirect()) {
            rule.setSalience(new SalienceInteger(Integer.MAX_VALUE));
        }
        this.setDeclarations(this.subrule.getOuterDeclarations());
        this.initDeclaredMask(context);
        this.initInferredMask();
        this.hashcode = this.calculateHashCode();
    }

    public void setDeclarations(Map<String, Declaration> decls) {
        this.setEnabledDeclarations(this.rule.findEnabledDeclarations(decls));
        this.setSalienceDeclarations(this.rule.findSalienceDeclarations(decls));
    }

    @Override
    public RuleImpl getRule() {
        return this.rule;
    }

    @Override
    public GroupElement getSubRule() {
        return this.subrule;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[RuleTerminalNode(").append(this.getId()).append("): rule=").append(this.rule.getName());
        if (this.consequenceName != null) {
            sb.append(", consequence=").append(this.consequenceName);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.getLeftTupleSource().addTupleSink(this, context);
        this.addAssociation(context, (Rule)context.getRule());
    }

    @Override
    public Declaration[] getAllDeclarations() {
        return this.allDeclarations;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    private void initDeclarations() {
        Map<String, Declaration> decls = this.subrule.getOuterDeclarations();
        this.allDeclarations = decls.values().toArray(new Declaration[decls.size()]);
        String[] requiredDeclarationNames = this.rule.getRequiredDeclarationsForConsequence(this.getConsequenceName());
        this.requiredDeclarations = new Declaration[requiredDeclarationNames.length];
        int i = 0;
        for (String str : requiredDeclarationNames) {
            this.requiredDeclarations[i++] = decls.get(str);
        }
    }

    @Override
    public Declaration[] getSalienceDeclarations() {
        return this.salienceDeclarations;
    }

    public void setSalienceDeclarations(Declaration[] salienceDeclarations) {
        this.salienceDeclarations = salienceDeclarations;
    }

    public Declaration[] getEnabledDeclarations() {
        return this.enabledDeclarations;
    }

    public void setEnabledDeclarations(Declaration[] enabledDeclarations) {
        this.enabledDeclarations = enabledDeclarations;
    }

    public String getConsequenceName() {
        return this.consequenceName == null ? "default" : this.consequenceName;
    }

    public void cancelMatch(AgendaItem match, ReteEvaluator reteEvaluator) {
        match.cancel();
        if (match.isQueued()) {
            Tuple leftTuple = match.getTuple();
            if (match.getRuleAgendaItem() != null && leftTuple.getMemory() != null) {
                leftTuple.getMemory().remove(leftTuple);
            }
            RuleExecutor ruleExecutor = ((RuleTerminalNodeLeftTuple)leftTuple).getRuleAgendaItem().getRuleExecutor();
            PhreakRuleTerminalNode.doLeftDelete(ruleExecutor.getPathMemory().getActualActivationsManager(reteEvaluator), ruleExecutor, leftTuple);
        }
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    private int calculateHashCode() {
        return 31 * this.rule.hashCode() + (this.consequenceName == null ? 0 : 37 * this.consequenceName.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof RuleTerminalNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        RuleTerminalNode other = (RuleTerminalNode)object;
        return this.rule.equals(other.rule) && (this.consequenceName == null ? other.consequenceName == null : this.consequenceName.equals(other.consequenceName));
    }

    @Override
    public short getType() {
        return 101;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return AgendaComponentFactory.get().createTerminalTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return AgendaComponentFactory.get().createTerminalTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return AgendaComponentFactory.get().createTerminalTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return AgendaComponentFactory.get().createTerminalTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return AgendaComponentFactory.get().createTerminalTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode.Id getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    @Override
    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    @Override
    public boolean isFireDirect() {
        return this.fireDirect;
    }

    public void setFireDirect(boolean fireDirect) {
        this.fireDirect = fireDirect;
    }

    public static class SortDeclarations
    implements Comparator<Declaration> {
        public static final SortDeclarations instance = new SortDeclarations();

        @Override
        public int compare(Declaration d1, Declaration d2) {
            return d1.getIdentifier().compareTo(d2.getIdentifier());
        }
    }
}

