/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import org.drools.core.base.ValueType;
import org.drools.core.base.extractors.ConstantValueReader;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.base.field.ObjectFieldImpl;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.time.Interval;
import org.kie.api.runtime.rule.Operator;

public class EvaluatorWrapper
implements Evaluator {
    private static final long serialVersionUID = 520L;
    private static final SelfReferenceClassFieldReader extractor = new SelfReferenceClassFieldReader(Object.class);
    private Evaluator evaluator;
    private Declaration leftBinding;
    private Declaration rightBinding;
    private boolean selfLeft;
    private boolean selfRight;
    private String bindingName;
    private transient boolean rightLiteral;
    private transient Long leftTimestamp;
    private transient Long rightTimestamp;

    public EvaluatorWrapper(Evaluator evaluator, Declaration leftBinding, Declaration rightBinding) {
        this.evaluator = evaluator;
        this.leftBinding = leftBinding;
        this.rightBinding = rightBinding;
        this.init();
    }

    private void init() {
        this.selfLeft = this.leftBinding == null || this.leftBinding.getIdentifier().equals("this");
        this.selfRight = this.rightBinding == null || this.rightBinding.getIdentifier().equals("this");
    }

    public boolean evaluate(ReteEvaluator reteEvaluator, Object left, Object right) {
        Object leftValue = this.leftTimestamp != null ? this.leftTimestamp : left;
        Object rightValue = this.rightTimestamp != null ? this.rightTimestamp : right;
        return this.rightLiteral ? this.evaluator.evaluate(reteEvaluator, new ConstantValueReader(leftValue), InternalFactHandle.dummyFactHandleOf(leftValue), new ObjectFieldImpl(rightValue)) : this.evaluator.evaluate(reteEvaluator, new ConstantValueReader(leftValue), InternalFactHandle.dummyFactHandleOf(leftValue), new ConstantValueReader(rightValue), InternalFactHandle.dummyFactHandleOf(rightValue));
    }

    @Override
    public ValueType getValueType() {
        return this.evaluator.getValueType();
    }

    @Override
    public Operator getOperator() {
        return this.evaluator.getOperator();
    }

    @Override
    public ValueType getCoercedValueType() {
        return this.evaluator.getCoercedValueType();
    }

    @Override
    public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle factHandle, FieldValue value) {
        return this.evaluator.evaluate(reteEvaluator, extractor, factHandle, value);
    }

    @Override
    public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor leftExtractor, InternalFactHandle left, InternalReadAccessor rightExtractor, InternalFactHandle right) {
        return this.evaluator.evaluate(reteEvaluator, leftExtractor, left, rightExtractor, right);
    }

    @Override
    public boolean isTemporal() {
        return this.evaluator.isTemporal();
    }

    @Override
    public Interval getInterval() {
        return this.evaluator.getInterval();
    }

    public void loadHandles(InternalFactHandle[] handles, InternalFactHandle rightHandle) {
        InternalFactHandle localLeftHandle = null;
        InternalFactHandle localRightHandle = null;
        if (!this.selfLeft && handles != null) {
            localLeftHandle = EvaluatorWrapper.getFactHandle(this.leftBinding, handles);
        }
        if (this.selfRight) {
            localRightHandle = rightHandle;
        } else if (handles != null) {
            localRightHandle = EvaluatorWrapper.getFactHandle(this.rightBinding, handles);
        }
        boolean bl = this.rightLiteral = localRightHandle == null;
        if (this.isTemporal()) {
            if (localLeftHandle == null) {
                localLeftHandle = rightHandle;
            }
            this.leftTimestamp = localLeftHandle instanceof EventFactHandle ? Long.valueOf(((EventFactHandle)localLeftHandle).getStartTimestamp()) : null;
            this.rightTimestamp = localRightHandle instanceof EventFactHandle ? Long.valueOf(((EventFactHandle)localRightHandle).getStartTimestamp()) : null;
        }
    }

    public String toString() {
        return this.evaluator.toString();
    }

    public static SelfReferenceClassFieldReader getExtractor() {
        return extractor;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    private static InternalFactHandle getFactHandle(Declaration declaration, InternalFactHandle[] handles) {
        return handles[declaration.getObjectIndex()];
    }
}

