/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.stream.tri;

import java.math.BigDecimal;
import java.util.function.Function;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.quad.NoneQuadJoiner;

public interface TriConstraintStream<A, B, C>
extends ConstraintStream {
    public TriConstraintStream<A, B, C> filter(TriPredicate<A, B, C> var1);

    default public <D> QuadConstraintStream<A, B, C, D> join(UniConstraintStream<D> otherStream) {
        return this.join(otherStream, (QuadJoiner<A, B, C, D>)new NoneQuadJoiner());
    }

    public <D> QuadConstraintStream<A, B, C, D> join(UniConstraintStream<D> var1, QuadJoiner<A, B, C, D> var2);

    default public <D> QuadConstraintStream<A, B, C, D> join(UniConstraintStream<D> otherStream, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2) {
        return this.join(otherStream, new QuadJoiner[]{joiner1, joiner2});
    }

    default public <D> QuadConstraintStream<A, B, C, D> join(UniConstraintStream<D> otherStream, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3) {
        return this.join(otherStream, new QuadJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <D> QuadConstraintStream<A, B, C, D> join(UniConstraintStream<D> otherStream, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3, QuadJoiner<A, B, C, D> joiner4) {
        return this.join(otherStream, new QuadJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <D> QuadConstraintStream<A, B, C, D> join(UniConstraintStream<D> var1, QuadJoiner<A, B, C, D> ... var2);

    default public <D> QuadConstraintStream<A, B, C, D> join(Class<D> otherClass) {
        return this.join(otherClass, (QuadJoiner<A, B, C, D>)new NoneQuadJoiner());
    }

    default public <D> QuadConstraintStream<A, B, C, D> join(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner) {
        return this.join(otherClass, new QuadJoiner[]{joiner});
    }

    default public <D> QuadConstraintStream<A, B, C, D> join(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2) {
        return this.join(otherClass, new QuadJoiner[]{joiner1, joiner2});
    }

    default public <D> QuadConstraintStream<A, B, C, D> join(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3) {
        return this.join(otherClass, new QuadJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <D> QuadConstraintStream<A, B, C, D> join(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3, QuadJoiner<A, B, C, D> joiner4) {
        return this.join(otherClass, new QuadJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <D> QuadConstraintStream<A, B, C, D> join(Class<D> var1, QuadJoiner<A, B, C, D> ... var2);

    default public <D> TriConstraintStream<A, B, C> ifExists(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner) {
        return this.ifExists(otherClass, new QuadJoiner[]{joiner});
    }

    default public <D> TriConstraintStream<A, B, C> ifExists(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2) {
        return this.ifExists(otherClass, new QuadJoiner[]{joiner1, joiner2});
    }

    default public <D> TriConstraintStream<A, B, C> ifExists(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3) {
        return this.ifExists(otherClass, new QuadJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <D> TriConstraintStream<A, B, C> ifExists(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3, QuadJoiner<A, B, C, D> joiner4) {
        return this.ifExists(otherClass, new QuadJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <D> TriConstraintStream<A, B, C> ifExists(Class<D> var1, QuadJoiner<A, B, C, D> ... var2);

    default public <D> TriConstraintStream<A, B, C> ifExistsIncludingNullVars(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner) {
        return this.ifExistsIncludingNullVars(otherClass, new QuadJoiner[]{joiner});
    }

    default public <D> TriConstraintStream<A, B, C> ifExistsIncludingNullVars(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2) {
        return this.ifExistsIncludingNullVars(otherClass, new QuadJoiner[]{joiner1, joiner2});
    }

    default public <D> TriConstraintStream<A, B, C> ifExistsIncludingNullVars(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3) {
        return this.ifExistsIncludingNullVars(otherClass, new QuadJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <D> TriConstraintStream<A, B, C> ifExistsIncludingNullVars(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3, QuadJoiner<A, B, C, D> joiner4) {
        return this.ifExistsIncludingNullVars(otherClass, new QuadJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <D> TriConstraintStream<A, B, C> ifExistsIncludingNullVars(Class<D> var1, QuadJoiner<A, B, C, D> ... var2);

    default public <D> TriConstraintStream<A, B, C> ifNotExists(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner) {
        return this.ifNotExists(otherClass, new QuadJoiner[]{joiner});
    }

    default public <D> TriConstraintStream<A, B, C> ifNotExists(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2) {
        return this.ifNotExists(otherClass, new QuadJoiner[]{joiner1, joiner2});
    }

    default public <D> TriConstraintStream<A, B, C> ifNotExists(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3) {
        return this.ifNotExists(otherClass, new QuadJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <D> TriConstraintStream<A, B, C> ifNotExists(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3, QuadJoiner<A, B, C, D> joiner4) {
        return this.ifNotExists(otherClass, new QuadJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <D> TriConstraintStream<A, B, C> ifNotExists(Class<D> var1, QuadJoiner<A, B, C, D> ... var2);

    default public <D> TriConstraintStream<A, B, C> ifNotExistsIncludingNullVars(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner) {
        return this.ifNotExistsIncludingNullVars(otherClass, new QuadJoiner[]{joiner});
    }

    default public <D> TriConstraintStream<A, B, C> ifNotExistsIncludingNullVars(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2) {
        return this.ifNotExistsIncludingNullVars(otherClass, new QuadJoiner[]{joiner1, joiner2});
    }

    default public <D> TriConstraintStream<A, B, C> ifNotExistsIncludingNullVars(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3) {
        return this.ifNotExistsIncludingNullVars(otherClass, new QuadJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <D> TriConstraintStream<A, B, C> ifNotExistsIncludingNullVars(Class<D> otherClass, QuadJoiner<A, B, C, D> joiner1, QuadJoiner<A, B, C, D> joiner2, QuadJoiner<A, B, C, D> joiner3, QuadJoiner<A, B, C, D> joiner4) {
        return this.ifNotExistsIncludingNullVars(otherClass, new QuadJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <D> TriConstraintStream<A, B, C> ifNotExistsIncludingNullVars(Class<D> var1, QuadJoiner<A, B, C, D> ... var2);

    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(TriConstraintCollector<A, B, C, ResultContainer_, Result_> var1);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(TriConstraintCollector<A, B, C, ResultContainerA_, ResultA_> var1, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> var2);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(TriConstraintCollector<A, B, C, ResultContainerA_, ResultA_> var1, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> var2, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> var3);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(TriConstraintCollector<A, B, C, ResultContainerA_, ResultA_> var1, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> var2, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> var3, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> var4);

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(TriFunction<A, B, C, GroupKey_> var1);

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(TriFunction<A, B, C, GroupKey_> var1, TriConstraintCollector<A, B, C, ResultContainer_, Result_> var2);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(TriFunction<A, B, C, GroupKey_> var1, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> var2, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> var3);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(TriFunction<A, B, C, GroupKey_> var1, TriConstraintCollector<A, B, C, ResultContainerB_, ResultB_> var2, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> var3, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(TriFunction<A, B, C, GroupKeyA_> var1, TriFunction<A, B, C, GroupKeyB_> var2);

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(TriFunction<A, B, C, GroupKeyA_> var1, TriFunction<A, B, C, GroupKeyB_> var2, TriConstraintCollector<A, B, C, ResultContainer_, Result_> var3);

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(TriFunction<A, B, C, GroupKeyA_> var1, TriFunction<A, B, C, GroupKeyB_> var2, TriConstraintCollector<A, B, C, ResultContainerC_, ResultC_> var3, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(TriFunction<A, B, C, GroupKeyA_> var1, TriFunction<A, B, C, GroupKeyB_> var2, TriFunction<A, B, C, GroupKeyC_> var3);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(TriFunction<A, B, C, GroupKeyA_> var1, TriFunction<A, B, C, GroupKeyB_> var2, TriFunction<A, B, C, GroupKeyC_> var3, TriConstraintCollector<A, B, C, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(TriFunction<A, B, C, GroupKeyA_> var1, TriFunction<A, B, C, GroupKeyB_> var2, TriFunction<A, B, C, GroupKeyC_> var3, TriFunction<A, B, C, GroupKeyD_> var4);

    public <ResultA_> UniConstraintStream<ResultA_> map(TriFunction<A, B, C, ResultA_> var1);

    public <ResultC_> TriConstraintStream<A, B, ResultC_> flattenLast(Function<C, Iterable<ResultC_>> var1);

    public TriConstraintStream<A, B, C> distinct();

    default public Constraint penalize(String constraintName, Score<?> constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.penalize(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalize(String var1, String var2, Score<?> var3, ToIntTriFunction<A, B, C> var4);

    default public Constraint penalizeLong(String constraintName, Score<?> constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.penalizeLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalizeLong(String var1, String var2, Score<?> var3, ToLongTriFunction<A, B, C> var4);

    default public Constraint penalizeBigDecimal(String constraintName, Score<?> constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalizeBigDecimal(String var1, String var2, Score<?> var3, TriFunction<A, B, C, BigDecimal> var4);

    default public Constraint penalizeConfigurable(String constraintName, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.penalizeConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurable(String var1, String var2, ToIntTriFunction<A, B, C> var3);

    default public Constraint penalizeConfigurableLong(String constraintName, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.penalizeConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurableLong(String var1, String var2, ToLongTriFunction<A, B, C> var3);

    default public Constraint penalizeConfigurableBigDecimal(String constraintName, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurableBigDecimal(String var1, String var2, TriFunction<A, B, C, BigDecimal> var3);

    default public Constraint reward(String constraintName, Score<?> constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.reward(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint reward(String var1, String var2, Score<?> var3, ToIntTriFunction<A, B, C> var4);

    default public Constraint rewardLong(String constraintName, Score<?> constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.rewardLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint rewardLong(String var1, String var2, Score<?> var3, ToLongTriFunction<A, B, C> var4);

    default public Constraint rewardBigDecimal(String constraintName, Score<?> constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint rewardBigDecimal(String var1, String var2, Score<?> var3, TriFunction<A, B, C, BigDecimal> var4);

    default public Constraint rewardConfigurable(String constraintName, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.rewardConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurable(String var1, String var2, ToIntTriFunction<A, B, C> var3);

    default public Constraint rewardConfigurableLong(String constraintName, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.rewardConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurableLong(String var1, String var2, ToLongTriFunction<A, B, C> var3);

    default public Constraint rewardConfigurableBigDecimal(String constraintName, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurableBigDecimal(String var1, String var2, TriFunction<A, B, C, BigDecimal> var3);

    default public Constraint impact(String constraintName, Score<?> constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.impact(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint impact(String var1, String var2, Score<?> var3, ToIntTriFunction<A, B, C> var4);

    default public Constraint impactLong(String constraintName, Score<?> constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.impactLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint impactLong(String var1, String var2, Score<?> var3, ToLongTriFunction<A, B, C> var4);

    default public Constraint impactBigDecimal(String constraintName, Score<?> constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint impactBigDecimal(String var1, String var2, Score<?> var3, TriFunction<A, B, C, BigDecimal> var4);

    default public Constraint impactConfigurable(String constraintName, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.impactConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint impactConfigurable(String var1, String var2, ToIntTriFunction<A, B, C> var3);

    default public Constraint impactConfigurableLong(String constraintName, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.impactConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint impactConfigurableLong(String var1, String var2, ToLongTriFunction<A, B, C> var3);

    default public Constraint impactConfigurableBigDecimal(String constraintName, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint impactConfigurableBigDecimal(String var1, String var2, TriFunction<A, B, C, BigDecimal> var3);
}

