/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.api.domain.solution.cloner.DeepPlanningClone;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.solution.cloner.ConcurrentMemoization;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.util.Pair;

public final class DeepCloningUtils {
    private final SolutionDescriptor<?> solutionDescriptor;
    private final ConcurrentMap<Pair<Field, Class<?>>, Boolean> fieldDeepClonedMemoization;
    private final ConcurrentMap<Class<?>, Boolean> actualValueClassDeepClonedMemoization;

    public DeepCloningUtils(SolutionDescriptor<?> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
        this.fieldDeepClonedMemoization = new ConcurrentMemoization();
        this.actualValueClassDeepClonedMemoization = new ConcurrentMemoization();
    }

    public boolean getDeepCloneDecision(Field field, Class<?> owningClass, Class<?> actualValueClass) {
        Pair<Field, Class<?>> pair = Pair.of(field, owningClass);
        Boolean deepCloneDecision = this.fieldDeepClonedMemoization.computeIfAbsent(pair, key -> this.isFieldDeepCloned(field, owningClass));
        return deepCloneDecision != false || this.actualValueClassDeepClonedMemoization.computeIfAbsent(actualValueClass, key -> this.isClassDeepCloned(actualValueClass)) != false;
    }

    public boolean retrieveDeepCloneDecisionForActualValueClass(Class<?> actualValueClass) {
        return this.actualValueClassDeepClonedMemoization.computeIfAbsent(actualValueClass, key -> this.isClassDeepCloned(actualValueClass));
    }

    public boolean isFieldDeepCloned(Field field, Class<?> owningClass) {
        if (field.getType().isEnum()) {
            return false;
        }
        return this.isFieldAnEntityPropertyOnSolution(field, owningClass) || this.isFieldAnEntityOrSolution(field) || this.isFieldADeepCloneProperty(field, owningClass);
    }

    public boolean isFieldAnEntityPropertyOnSolution(Field field, Class<?> owningClass) {
        if (!this.solutionDescriptor.getSolutionClass().isAssignableFrom(owningClass)) {
            return false;
        }
        String fieldName = field.getName();
        if (this.solutionDescriptor.getEntityMemberAccessorMap().get(fieldName) != null) {
            return true;
        }
        return this.solutionDescriptor.getEntityCollectionMemberAccessorMap().get(fieldName) != null;
    }

    public boolean isFieldAnEntityOrSolution(Field field) {
        Class<?> type = field.getType();
        if (this.isClassDeepCloned(type)) {
            return true;
        }
        return Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) ? this.isTypeArgumentDeepCloned(field.getGenericType()) : type.isArray() && this.isClassDeepCloned(type.getComponentType());
    }

    public boolean isClassDeepCloned(Class<?> type) {
        return this.solutionDescriptor.hasEntityDescriptor(type) || this.solutionDescriptor.getSolutionClass().isAssignableFrom(type) || type.isAnnotationPresent(DeepPlanningClone.class);
    }

    public boolean isTypeArgumentDeepCloned(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                if (actualTypeArgument instanceof Class && this.isClassDeepCloned((Class)actualTypeArgument)) {
                    return true;
                }
                if (!this.isTypeArgumentDeepCloned(actualTypeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFieldADeepCloneProperty(Field field, Class<?> owningClass) {
        if (field.isAnnotationPresent(DeepPlanningClone.class)) {
            return true;
        }
        Method getterMethod = ReflectionHelper.getGetterMethod(owningClass, field.getName());
        return getterMethod != null && getterMethod.isAnnotationPresent(DeepPlanningClone.class);
    }

    public Set<Class<?>> getDeepClonedTypeArguments(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return Collections.emptySet();
        }
        HashSet deepClonedTypeArguments = new HashSet();
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
            if (actualTypeArgument instanceof Class && this.isClassDeepCloned((Class)actualTypeArgument)) {
                deepClonedTypeArguments.add((Class)actualTypeArgument);
            }
            deepClonedTypeArguments.addAll(this.getDeepClonedTypeArguments(actualTypeArgument));
        }
        return deepClonedTypeArguments;
    }

    public Set<Class<?>> getDeepClonedClasses(Collection<Class<?>> entitySubclasses) {
        HashSet deepClonedClassSet = new HashSet();
        Stream.of(Stream.of(this.solutionDescriptor.getSolutionClass()), this.solutionDescriptor.getEntityClassSet().stream(), entitySubclasses.stream()).flatMap(classStream -> classStream).forEach(clazz -> {
            deepClonedClassSet.add((Class<?>)clazz);
            for (Field field : DeepCloningUtils.getAllFields(clazz)) {
                deepClonedClassSet.addAll(this.getDeepClonedTypeArguments(field.getGenericType()));
                if (!this.isClassDeepCloned(field.getType())) continue;
                deepClonedClassSet.add(field.getType());
            }
        });
        return deepClonedClassSet;
    }

    private static List<Field> getAllFields(Class<?> baseClass) {
        Stream<Object> memberStream = Stream.empty();
        for (Class<?> clazz = baseClass; clazz != null; clazz = clazz.getSuperclass()) {
            Stream<Field> fieldStream = Stream.of(clazz.getDeclaredFields());
            memberStream = Stream.concat(memberStream, fieldStream);
        }
        return memberStream.collect(Collectors.toList());
    }
}

