/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drl.holder;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScoreHolder;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;

public final class SimpleBigDecimalScoreHolderImpl
extends AbstractScoreHolder<SimpleBigDecimalScore>
implements SimpleBigDecimalScoreHolder {
    protected final Map<Rule, AbstractScoreHolder.BigDecimalMatchExecutor> matchExecutorByNumberMap = new LinkedHashMap<Rule, AbstractScoreHolder.BigDecimalMatchExecutor>();
    protected BigDecimal score = BigDecimal.ZERO;

    public SimpleBigDecimalScoreHolderImpl(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public BigDecimal getScore() {
        return this.score;
    }

    @Override
    public void configureConstraintWeight(Rule rule, SimpleBigDecimalScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        AbstractScoreHolder.BigDecimalMatchExecutor matchExecutor = constraintWeight.isZero() ? (kcontext, matchWeight) -> {} : (kcontext, matchWeight) -> this.addConstraintMatch(kcontext, constraintWeight.getScore().multiply(matchWeight));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
    }

    @Override
    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE.negate());
    }

    @Override
    public void penalize(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier.negate());
    }

    @Override
    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE);
    }

    @Override
    public void reward(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, BigDecimal.valueOf(weightMultiplier));
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, BigDecimal.valueOf(weightMultiplier));
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.BigDecimalMatchExecutor matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    @Override
    public void addConstraintMatch(RuleContext kcontext, BigDecimal weight) {
        this.score = this.score.add(weight);
        this.registerConstraintMatch(kcontext, () -> {
            this.score = this.score.subtract(weight);
        }, () -> SimpleBigDecimalScore.of(weight));
    }

    @Override
    public SimpleBigDecimalScore extractScore(int initScore) {
        return SimpleBigDecimalScore.ofUninitialized(initScore, this.score);
    }
}

