/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.scope;

import io.micrometer.core.instrument.Tags;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;
import org.optaplanner.core.config.solver.monitoring.SolverMetric;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;

public class SolverScope<Solution_> {
    protected Set<SolverMetric> solverMetricSet;
    protected Tags monitoringTags;
    protected int startingSolverCount;
    protected Random workingRandom;
    protected InnerScoreDirector<Solution_, ?> scoreDirector;
    private ProblemChangeDirector problemChangeDirector;
    protected Semaphore runnableThreadSemaphore = null;
    protected volatile Long startingSystemTimeMillis;
    protected volatile Long endingSystemTimeMillis;
    protected long childThreadsScoreCalculationCount = 0L;
    protected Score startingInitializedScore;
    protected volatile Solution_ bestSolution;
    protected volatile Score bestScore;
    protected Long bestSolutionTimeMillis;
    protected final Map<Tags, List<AtomicReference<Number>>> stepScoreMap = new ConcurrentHashMap<Tags, List<AtomicReference<Number>>>();

    public ProblemChangeDirector getProblemChangeDirector() {
        return this.problemChangeDirector;
    }

    public void setProblemChangeDirector(ProblemChangeDirector problemChangeDirector) {
        this.problemChangeDirector = problemChangeDirector;
    }

    public Tags getMonitoringTags() {
        return this.monitoringTags;
    }

    public void setMonitoringTags(Tags monitoringTags) {
        this.monitoringTags = monitoringTags;
    }

    public Map<Tags, List<AtomicReference<Number>>> getStepScoreMap() {
        return this.stepScoreMap;
    }

    public Set<SolverMetric> getSolverMetricSet() {
        return this.solverMetricSet;
    }

    public void setSolverMetricSet(EnumSet<SolverMetric> solverMetricSet) {
        this.solverMetricSet = solverMetricSet;
    }

    public int getStartingSolverCount() {
        return this.startingSolverCount;
    }

    public void setStartingSolverCount(int startingSolverCount) {
        this.startingSolverCount = startingSolverCount;
    }

    public Random getWorkingRandom() {
        return this.workingRandom;
    }

    public void setWorkingRandom(Random workingRandom) {
        this.workingRandom = workingRandom;
    }

    public <Score_ extends Score<Score_>> InnerScoreDirector<Solution_, Score_> getScoreDirector() {
        return this.scoreDirector;
    }

    public void setScoreDirector(InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.scoreDirector = scoreDirector;
    }

    public void setRunnableThreadSemaphore(Semaphore runnableThreadSemaphore) {
        this.runnableThreadSemaphore = runnableThreadSemaphore;
    }

    public Long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public Long getEndingSystemTimeMillis() {
        return this.endingSystemTimeMillis;
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.scoreDirector.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDirector.getScoreDefinition();
    }

    public Solution_ getWorkingSolution() {
        return this.scoreDirector.getWorkingSolution();
    }

    public int getWorkingEntityCount() {
        return this.getSolutionDescriptor().getEntityCount(this.getWorkingSolution());
    }

    public int getWorkingValueCount() {
        return this.getSolutionDescriptor().getValueCount(this.getWorkingSolution());
    }

    public Score calculateScore() {
        return this.scoreDirector.calculateScore();
    }

    public void assertScoreFromScratch(Solution_ solution) {
        this.scoreDirector.getScoreDirectorFactory().assertScoreFromScratch(solution);
    }

    public Score getStartingInitializedScore() {
        return this.startingInitializedScore;
    }

    public void setStartingInitializedScore(Score startingInitializedScore) {
        this.startingInitializedScore = startingInitializedScore;
    }

    public void addChildThreadsScoreCalculationCount(long addition) {
        this.childThreadsScoreCalculationCount += addition;
    }

    public long getScoreCalculationCount() {
        return this.scoreDirector.getCalculationCount() + this.childThreadsScoreCalculationCount;
    }

    public Solution_ getBestSolution() {
        return this.bestSolution;
    }

    public void setBestSolution(Solution_ bestSolution) {
        this.bestSolution = bestSolution;
    }

    public Score getBestScore() {
        return this.bestScore;
    }

    public void setBestScore(Score bestScore) {
        this.bestScore = bestScore;
    }

    public Long getBestSolutionTimeMillis() {
        return this.bestSolutionTimeMillis;
    }

    public void setBestSolutionTimeMillis(Long bestSolutionTimeMillis) {
        this.bestSolutionTimeMillis = bestSolutionTimeMillis;
    }

    public boolean isMetricEnabled(SolverMetric solverMetric) {
        return this.solverMetricSet.contains((Object)solverMetric);
    }

    public void startingNow() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.endingSystemTimeMillis = null;
    }

    public Long getBestSolutionTimeMillisSpent() {
        return this.bestSolutionTimeMillis - this.startingSystemTimeMillis;
    }

    public void endingNow() {
        this.endingSystemTimeMillis = System.currentTimeMillis();
    }

    public boolean isBestSolutionInitialized() {
        return this.bestScore.isSolutionInitialized();
    }

    public long calculateTimeMillisSpentUpToNow() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    public long getTimeMillisSpent() {
        return this.endingSystemTimeMillis - this.startingSystemTimeMillis;
    }

    public long getScoreCalculationSpeed() {
        long timeMillisSpent = this.getTimeMillisSpent();
        return this.getScoreCalculationCount() * 1000L / (timeMillisSpent == 0L ? 1L : timeMillisSpent);
    }

    public void setWorkingSolutionFromBestSolution() {
        this.scoreDirector.setWorkingSolution(this.scoreDirector.cloneSolution(this.bestSolution));
    }

    public SolverScope<Solution_> createChildThreadSolverScope(ChildThreadType childThreadType) {
        SolverScope<Solution_> childThreadSolverScope = new SolverScope<Solution_>();
        childThreadSolverScope.monitoringTags = this.monitoringTags;
        childThreadSolverScope.solverMetricSet = this.solverMetricSet;
        childThreadSolverScope.startingSolverCount = this.startingSolverCount;
        childThreadSolverScope.workingRandom = new Random(this.workingRandom.nextLong());
        childThreadSolverScope.scoreDirector = this.scoreDirector.createChildThreadScoreDirector(childThreadType);
        childThreadSolverScope.startingSystemTimeMillis = this.startingSystemTimeMillis;
        childThreadSolverScope.endingSystemTimeMillis = null;
        childThreadSolverScope.startingInitializedScore = null;
        childThreadSolverScope.bestSolution = null;
        childThreadSolverScope.bestScore = null;
        childThreadSolverScope.bestSolutionTimeMillis = null;
        return childThreadSolverScope;
    }

    public void initializeYielding() {
        if (this.runnableThreadSemaphore != null) {
            try {
                this.runnableThreadSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void checkYielding() {
        if (this.runnableThreadSemaphore != null) {
            this.runnableThreadSemaphore.release();
            try {
                this.runnableThreadSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void destroyYielding() {
        if (this.runnableThreadSemaphore != null) {
            this.runnableThreadSemaphore.release();
        }
    }
}

