/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoft;

import java.util.Objects;
import org.optaplanner.core.api.score.AbstractScore;

public final class HardMediumSoftScore
extends AbstractScore<HardMediumSoftScore> {
    public static final HardMediumSoftScore ZERO = new HardMediumSoftScore(0, 0, 0, 0);
    public static final HardMediumSoftScore ONE_HARD = new HardMediumSoftScore(0, 1, 0, 0);
    public static final HardMediumSoftScore ONE_MEDIUM = new HardMediumSoftScore(0, 0, 1, 0);
    public static final HardMediumSoftScore ONE_SOFT = new HardMediumSoftScore(0, 0, 0, 1);
    private static final String HARD_LABEL = "hard";
    private static final String MEDIUM_LABEL = "medium";
    private static final String SOFT_LABEL = "soft";
    private final int hardScore;
    private final int mediumScore;
    private final int softScore;

    public static HardMediumSoftScore parseScore(String scoreString) {
        String[] scoreTokens = HardMediumSoftScore.parseScoreTokens(HardMediumSoftScore.class, scoreString, HARD_LABEL, MEDIUM_LABEL, SOFT_LABEL);
        int initScore = HardMediumSoftScore.parseInitScore(HardMediumSoftScore.class, scoreString, scoreTokens[0]);
        int hardScore = HardMediumSoftScore.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[1]);
        int mediumScore = HardMediumSoftScore.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[2]);
        int softScore = HardMediumSoftScore.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[3]);
        return HardMediumSoftScore.ofUninitialized(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftScore ofUninitialized(int initScore, int hardScore, int mediumScore, int softScore) {
        return new HardMediumSoftScore(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftScore of(int hardScore, int mediumScore, int softScore) {
        return new HardMediumSoftScore(0, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftScore ofHard(int hardScore) {
        return HardMediumSoftScore.of(hardScore, 0, 0);
    }

    public static HardMediumSoftScore ofMedium(int mediumScore) {
        return HardMediumSoftScore.of(0, mediumScore, 0);
    }

    public static HardMediumSoftScore ofSoft(int softScore) {
        return HardMediumSoftScore.of(0, 0, softScore);
    }

    private HardMediumSoftScore() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private HardMediumSoftScore(int initScore, int hardScore, int mediumScore, int softScore) {
        super(initScore);
        this.hardScore = hardScore;
        this.mediumScore = mediumScore;
        this.softScore = softScore;
    }

    public int getHardScore() {
        return this.hardScore;
    }

    public int getMediumScore() {
        return this.mediumScore;
    }

    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardMediumSoftScore withInitScore(int newInitScore) {
        return new HardMediumSoftScore(newInitScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0;
    }

    @Override
    public HardMediumSoftScore add(HardMediumSoftScore addend) {
        return new HardMediumSoftScore(this.initScore + addend.getInitScore(), this.hardScore + addend.getHardScore(), this.mediumScore + addend.getMediumScore(), this.softScore + addend.getSoftScore());
    }

    @Override
    public HardMediumSoftScore subtract(HardMediumSoftScore subtrahend) {
        return new HardMediumSoftScore(this.initScore - subtrahend.getInitScore(), this.hardScore - subtrahend.getHardScore(), this.mediumScore - subtrahend.getMediumScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardMediumSoftScore multiply(double multiplicand) {
        return new HardMediumSoftScore((int)Math.floor((double)this.initScore * multiplicand), (int)Math.floor((double)this.hardScore * multiplicand), (int)Math.floor((double)this.mediumScore * multiplicand), (int)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardMediumSoftScore divide(double divisor) {
        return new HardMediumSoftScore((int)Math.floor((double)this.initScore / divisor), (int)Math.floor((double)this.hardScore / divisor), (int)Math.floor((double)this.mediumScore / divisor), (int)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public HardMediumSoftScore power(double exponent) {
        return new HardMediumSoftScore((int)Math.floor(Math.pow(this.initScore, exponent)), (int)Math.floor(Math.pow(this.hardScore, exponent)), (int)Math.floor(Math.pow(this.mediumScore, exponent)), (int)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public HardMediumSoftScore negate() {
        return new HardMediumSoftScore(-this.initScore, -this.hardScore, -this.mediumScore, -this.softScore);
    }

    @Override
    public HardMediumSoftScore zero() {
        return ZERO;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.mediumScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardMediumSoftScore) {
            HardMediumSoftScore other = (HardMediumSoftScore)o;
            return this.initScore == other.getInitScore() && this.hardScore == other.getHardScore() && this.mediumScore == other.getMediumScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public int compareTo(HardMediumSoftScore other) {
        if (this.initScore != other.getInitScore()) {
            return Integer.compare(this.initScore, other.getInitScore());
        }
        if (this.hardScore != other.getHardScore()) {
            return Integer.compare(this.hardScore, other.getHardScore());
        }
        if (this.mediumScore != other.getMediumScore()) {
            return Integer.compare(this.mediumScore, other.getMediumScore());
        }
        return Integer.compare(this.softScore, other.getSoftScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> n.intValue() != 0, HARD_LABEL, MEDIUM_LABEL, SOFT_LABEL);
    }

    public String toString() {
        return this.getInitPrefix() + this.hardScore + "hard/" + this.mediumScore + "medium/" + this.softScore + SOFT_LABEL;
    }
}

