/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PhreakPropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.Behavior;
import org.drools.core.spi.PropagationContext;

public class SlidingLengthWindow
implements Externalizable,
Behavior {
    protected int size;

    public SlidingLengthWindow() {
        this(0);
    }

    public SlidingLengthWindow(int size) {
        this.size = size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
    }

    @Override
    public Behavior.BehaviorType getType() {
        return Behavior.BehaviorType.LENGTH_WINDOW;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public Behavior.Context createContext() {
        return new SlidingLengthWindowContext(this.size);
    }

    @Override
    public boolean assertFact(Object context, InternalFactHandle handle, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        SlidingLengthWindowContext window = (SlidingLengthWindowContext)context;
        window.pos = (window.pos + 1) % window.handles.length;
        if (window.handles[window.pos] != null) {
            EventFactHandle previous = window.handles[window.pos];
            PropagationContext expiresPctx = PhreakPropagationContextFactory.createPropagationContextForFact(reteEvaluator, previous, PropagationContext.Type.EXPIRATION);
            ObjectTypeNode.doRetractObject(previous, expiresPctx, reteEvaluator);
        }
        window.handles[window.pos] = (EventFactHandle)handle;
        return true;
    }

    @Override
    public void retractFact(Object context, InternalFactHandle handle, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        SlidingLengthWindowContext window = (SlidingLengthWindowContext)context;
        int last = window.pos == 0 ? window.handles.length - 1 : window.pos - 1;
        int i = window.pos;
        while (i != last) {
            if (window.handles[i] == handle) {
                window.handles[i] = null;
                break;
            }
            i = (i + 1) % window.handles.length;
        }
    }

    @Override
    public void expireFacts(Object context, PropagationContext pctx, ReteEvaluator reteEvaluator) {
    }

    @Override
    public long getExpirationOffset() {
        return -1L;
    }

    public String toString() {
        return "SlidingLengthWindow( size=" + this.size + " )";
    }

    public static class SlidingLengthWindowContext
    implements Behavior.Context,
    Externalizable {
        public EventFactHandle[] handles;
        public int pos = 0;

        public SlidingLengthWindowContext(int size) {
            this.handles = new EventFactHandle[size];
        }

        public SlidingLengthWindowContext() {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.pos = in.readInt();
            this.handles = (EventFactHandle[])in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.pos);
            out.writeObject(this.handles);
        }

        @Override
        public Collection<EventFactHandle> getFactHandles() {
            return Collections.emptyList();
        }
    }
}

