/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.kproject.models.ChannelModelImpl;
import org.drools.compiler.kproject.models.FileLoggerModelImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.ListenerModelImpl;
import org.drools.compiler.kproject.models.WorkItemHandlerModelImpl;
import org.drools.core.BeliefSystemType;
import org.kie.api.builder.model.ChannelModel;
import org.kie.api.builder.model.FileLoggerModel;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.ListenerModel;
import org.kie.api.builder.model.WorkItemHandlerModel;
import org.kie.api.runtime.conf.BeliefSystemTypeOption;
import org.kie.api.runtime.conf.ClockTypeOption;

public class KieSessionModelImpl
implements KieSessionModel {
    private String name;
    private KieSessionModel.KieSessionType type = KieSessionModel.KieSessionType.STATEFUL;
    private ClockTypeOption clockType = ClockTypeOption.REALTIME;
    private BeliefSystemTypeOption beliefSystem = BeliefSystemTypeOption.get((String)BeliefSystemType.SIMPLE.toString());
    private String scope;
    private KieBaseModelImpl kBase;
    private final List<ListenerModel> listeners = new ArrayList<ListenerModel>();
    private final List<WorkItemHandlerModel> wihs = new ArrayList<WorkItemHandlerModel>();
    private final List<ChannelModel> channels = new ArrayList<ChannelModel>();
    private Map<String, String> calendars;
    private boolean isDefault = false;
    private String consoleLogger;
    private FileLoggerModel fileLogger;
    private boolean directFiring = false;
    private boolean threadSafe = true;
    private boolean accumulateNullPropagation = false;

    public KieSessionModelImpl() {
    }

    public KieSessionModelImpl(KieBaseModelImpl kBase, String name) {
        this.kBase = kBase;
        this.name = name;
    }

    public KieBaseModelImpl getKieBaseModel() {
        return this.kBase;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setKBase(KieBaseModel kieBaseModel) {
        this.kBase = (KieBaseModelImpl)kieBaseModel;
    }

    public KieSessionModel setDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public boolean isDirectFiring() {
        return this.directFiring;
    }

    public KieSessionModel setDirectFiring(boolean directFiring) {
        this.directFiring = directFiring;
        return this;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public KieSessionModel setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
        return this;
    }

    public boolean isAccumulateNullPropagation() {
        return this.accumulateNullPropagation;
    }

    public KieSessionModel setAccumulateNullPropagation(boolean accumulateNullPropagation) {
        this.accumulateNullPropagation = accumulateNullPropagation;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public KieSessionModel setNameForUnmarshalling(String name) {
        this.name = name;
        return this;
    }

    public KieSessionModel.KieSessionType getType() {
        return this.type;
    }

    public KieSessionModel setType(KieSessionModel.KieSessionType type) {
        this.type = type;
        return this;
    }

    public ClockTypeOption getClockType() {
        return this.clockType;
    }

    public KieSessionModel setClockType(ClockTypeOption clockType) {
        this.clockType = clockType;
        return this;
    }

    public BeliefSystemTypeOption getBeliefSystem() {
        return this.beliefSystem;
    }

    public KieSessionModel setBeliefSystem(BeliefSystemTypeOption beliefSystem) {
        this.beliefSystem = beliefSystem;
        return this;
    }

    public KieSessionModel setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public ListenerModel newListenerModel(String type, ListenerModel.Kind kind) {
        ListenerModelImpl listenerModel = new ListenerModelImpl(this, type, kind);
        this.listeners.add(listenerModel);
        return listenerModel;
    }

    public List<ListenerModel> getListenerModels() {
        return this.listeners;
    }

    public List<ListenerModel> getListenerModels(ListenerModel.Kind kind) {
        ArrayList<ListenerModel> listeners = new ArrayList<ListenerModel>();
        for (ListenerModel listener : this.getListenerModels()) {
            if (listener.getKind() != kind) continue;
            listeners.add(listener);
        }
        return listeners;
    }

    public void addListenerModel(ListenerModel listener) {
        this.listeners.add(listener);
    }

    public WorkItemHandlerModel newWorkItemHandlerModel(String name, String type) {
        WorkItemHandlerModelImpl wihModel = new WorkItemHandlerModelImpl(this, name, type);
        this.wihs.add(wihModel);
        return wihModel;
    }

    public List<WorkItemHandlerModel> getWorkItemHandlerModels() {
        return this.wihs;
    }

    public void addWorkItemHandelerModel(WorkItemHandlerModel wih) {
        this.wihs.add(wih);
    }

    public ChannelModel newChannelModel(String name, String type) {
        ChannelModelImpl channelModel = new ChannelModelImpl(this, name, type);
        this.channels.add(channelModel);
        return channelModel;
    }

    public List<ChannelModel> getChannelModels() {
        return this.channels;
    }

    public void addChannelModel(ChannelModel channel) {
        this.channels.add(channel);
    }

    public KieSessionModel addCalendar(String name, String type) {
        if (this.calendars == null) {
            this.calendars = new HashMap<String, String>();
        }
        this.calendars.put(name, type);
        return this;
    }

    public Map<String, String> getCalendars() {
        return this.calendars == null ? Collections.emptyMap() : this.calendars;
    }

    public String getConsoleLogger() {
        return this.consoleLogger;
    }

    public KieSessionModel setConsoleLogger(String consoleLogger) {
        this.consoleLogger = consoleLogger;
        return this;
    }

    public FileLoggerModel getFileLogger() {
        return this.fileLogger;
    }

    public KieSessionModel setFileLogger(String fileName) {
        this.fileLogger = new FileLoggerModelImpl(fileName);
        return this;
    }

    public KieSessionModel setFileLogger(String fileName, int interval, boolean threaded) {
        this.fileLogger = new FileLoggerModelImpl(fileName, interval, threaded);
        return this;
    }

    public void setFileLogger(FileLoggerModel fileLogger) {
        this.fileLogger = fileLogger;
    }

    public void setCalendars(Map<String, String> calendars) {
        this.calendars = calendars;
    }

    public String toString() {
        return "KieSessionModelImpl{name='" + this.name + '\'' + ", type=" + this.type + ", clockType=" + this.clockType + ", kBase=" + this.kBase.getName() + ", isDefault=" + this.isDefault + ", threadSafe=" + this.threadSafe + '}';
    }
}

