/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public final class BavetConstraintSessionFactory<Solution_, Score_ extends Score<Score_>> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final List<BavetConstraint<Solution_>> constraintList;

    public BavetConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, List<BavetConstraint<Solution_>> constraintList) {
        this.solutionDescriptor = solutionDescriptor;
        this.constraintList = constraintList;
    }

    public BavetConstraintSession<Solution_, Score_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        Score zeroScore = scoreDefinition.getZeroScore();
        Map<BavetConstraint, Score> constraintToWeightMap = this.constraintList.stream().map(constraint -> {
            Object weight = constraint.extractConstraintWeight(workingSolution);
            return new Object[]{constraint, weight};
        }).filter(constraintAndWeight -> !constraintAndWeight[1].equals(zeroScore)).collect(Collectors.toMap(constraintAndWeight -> (BavetConstraint)constraintAndWeight[0], constraintAndWeight -> (Score)constraintAndWeight[1]));
        return new BavetConstraintSession(constraintMatchEnabled, scoreDefinition, constraintToWeightMap);
    }
}

