/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.drools.model.DSL;
import org.drools.model.DeclarationSource;
import org.drools.model.Variable;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Function3;
import org.drools.model.functions.Function4;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.TriFunction;

public final class DroolsVariableFactory {
    private final AtomicLong counter = new AtomicLong(0L);

    DroolsVariableFactory() {
    }

    private String generateUniqueId(String baseName) {
        return baseName + "_" + this.counter.incrementAndGet();
    }

    public <U, V extends U> Variable<V> createVariable(Class<U> clz, String baseName) {
        return DSL.declarationOf(clz, (String)this.generateUniqueId(baseName));
    }

    public <U> Variable<U> createVariable(String baseName) {
        return this.createVariable(Object.class, baseName);
    }

    public <U, V, Result_> Variable<Result_> createVariable(String baseName, Variable<U> source1, Variable<V> source2, BiFunction<U, V, Result_> mapping) {
        return DSL.declarationOf(Object.class, (String)this.generateUniqueId(baseName), (DeclarationSource)DSL.from(source1, source2, (Function2 & Serializable)(value1, value2) -> {
            Object result = mapping.apply(value1, value2);
            if (result instanceof Iterable) {
                return Collections.singleton(result);
            }
            return result;
        }));
    }

    public <U, V, W, Result_> Variable<Result_> createVariable(String baseName, Variable<U> source1, Variable<V> source2, Variable<W> source3, TriFunction<U, V, W, Result_> mapping) {
        return DSL.declarationOf(Object.class, (String)this.generateUniqueId(baseName), (DeclarationSource)DSL.from(source1, source2, source3, (Function3 & Serializable)(value1, value2, value3) -> {
            Object result = mapping.apply(value1, value2, value3);
            if (result instanceof Iterable) {
                return Collections.singleton(result);
            }
            return result;
        }));
    }

    public <U, V, W, Y, Result_> Variable<Result_> createVariable(String baseName, Variable<U> source1, Variable<V> source2, Variable<W> source3, Variable<Y> source4, QuadFunction<U, V, W, Y, Result_> mapping) {
        return DSL.declarationOf(Object.class, (String)this.generateUniqueId(baseName), (DeclarationSource)DSL.from(source1, source2, source3, source4, (Function4 & Serializable)(value1, value2, value3, value4) -> {
            Object result = mapping.apply(value1, value2, value3, value4);
            if (result instanceof Iterable) {
                return Collections.singleton(result);
            }
            return result;
        }));
    }

    public <U, Result_> Variable<Result_> createFlattenedVariable(String baseName, Variable<U> source, Function<U, Iterable<Result_>> mapping) {
        return DSL.declarationOf(Object.class, (String)this.generateUniqueId(baseName), (DeclarationSource)DSL.from(source, mapping::apply));
    }
}

