/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Objects;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.test.api.score.stream.MultiConstraintVerification;
import org.optaplanner.test.impl.score.stream.DefaultMultiConstraintAssertion;
import org.optaplanner.test.impl.score.stream.SessionBasedAssertionBuilder;

public final class DefaultMultiConstraintVerification<Solution_, Score_ extends Score<Score_>>
implements MultiConstraintVerification<Solution_> {
    private final AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;
    private final ConstraintProvider constraintProvider;
    private final SessionBasedAssertionBuilder<Solution_, Score_> sessionBasedAssertionBuilder;

    protected DefaultMultiConstraintVerification(AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, ConstraintProvider constraintProvider) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.constraintProvider = constraintProvider;
        this.sessionBasedAssertionBuilder = SessionBasedAssertionBuilder.create(scoreDirectorFactory);
    }

    @Override
    public final DefaultMultiConstraintAssertion<Solution_, Score_> given(Object ... facts) {
        return this.sessionBasedAssertionBuilder.multiConstraintGiven(this.constraintProvider, facts);
    }

    @Override
    public final DefaultMultiConstraintAssertion<Solution_, Score_> givenSolution(Solution_ solution) {
        try (InnerScoreDirector scoreDirector = this.scoreDirectorFactory.buildScoreDirector(true, true);){
            scoreDirector.setWorkingSolution(Objects.requireNonNull(solution));
            DefaultMultiConstraintAssertion defaultMultiConstraintAssertion = new DefaultMultiConstraintAssertion(this.constraintProvider, scoreDirector.calculateScore(), scoreDirector.getConstraintMatchTotalMap(), scoreDirector.getIndictmentMap());
            return defaultMultiConstraintAssertion;
        }
    }
}

