/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.listener.SourcedVariableListener;

public class ExternalizedSingletonListInverseVariableSupply<Solution_>
implements SourcedVariableListener<Solution_, Object>,
SingletonInverseVariableSupply {
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;
    protected Map<Object, Object> inverseEntityMap = null;

    public ExternalizedSingletonListInverseVariableSupply(ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(ScoreDirector<Solution_> scoreDirector) {
        this.inverseEntityMap = new IdentityHashMap<Object, Object>();
        this.sourceVariableDescriptor.getEntityDescriptor().getSolutionDescriptor().visitAllEntities(scoreDirector.getWorkingSolution(), this::insert);
    }

    @Override
    public void close() {
        this.inverseEntityMap = null;
    }

    @Override
    public boolean requiresUniqueEntityEvents() {
        return true;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert(entity);
    }

    @Override
    public void beforeVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.retract(entity);
    }

    @Override
    public void afterVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert(entity);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.retract(entity);
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    protected void insert(Object entity) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (Object value : listVariable) {
            Object oldInverseEntity = this.inverseEntityMap.put(value, entity);
            if (oldInverseEntity == null) continue;
            throw new IllegalStateException("The supply (" + this + ") is corrupted, because the entity (" + entity + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be inserted: one of its values (" + value + ") already has a non-null oldInverseEntity (" + oldInverseEntity + ").");
        }
    }

    protected void retract(Object entity) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (Object value : listVariable) {
            Object oldInverseEntity = this.inverseEntityMap.remove(value);
            if (oldInverseEntity == entity) continue;
            throw new IllegalStateException("The supply (" + this + ") is corrupted, because the entity (" + entity + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be retracted: one of its values (" + value + ") has an unexpected oldInverseEntity (" + oldInverseEntity + ").");
        }
    }

    @Override
    public Object getInverseSingleton(Object value) {
        return this.inverseEntityMap.get(value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getVariableName() + ")";
    }
}

