/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.util.List;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class SingletonListInverseVariableListener<Solution_>
implements VariableListener<Solution_, Object>,
SingletonInverseVariableSupply {
    protected final InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;

    public SingletonListInverseVariableListener(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor, ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public boolean requiresUniqueEntityEvents() {
        return true;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void beforeVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.retract((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void afterVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.retract((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    protected void insert(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (Object value : listVariable) {
            Object oldInverseEntity = this.shadowVariableDescriptor.getValue(value);
            if (oldInverseEntity != null) {
                throw new IllegalStateException("The entity (" + entity + ") has a list variable (" + this.sourceVariableDescriptor.getVariableName() + ") and one of its values (" + value + ") which has a shadow variable (" + this.shadowVariableDescriptor.getVariableName() + ") has an oldInverseEntity (" + oldInverseEntity + ") which is not null.\nVerify the consistency of your input problem for that shadow variable.");
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, value);
            this.shadowVariableDescriptor.setValue(value, entity);
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, value);
        }
    }

    protected void retract(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (Object value : listVariable) {
            Object oldInverseEntity = this.shadowVariableDescriptor.getValue(value);
            if (oldInverseEntity != entity) {
                throw new IllegalStateException("The entity (" + entity + ") has a list variable (" + this.sourceVariableDescriptor.getVariableName() + ") and one of its values (" + value + ") which has a shadow variable (" + this.shadowVariableDescriptor.getVariableName() + ") has an oldInverseEntity (" + oldInverseEntity + ") which is not that entity.\nVerify the consistency of your input problem for that shadow variable.");
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, value);
            this.shadowVariableDescriptor.setValue(value, null);
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, value);
        }
    }

    @Override
    public Object getInverseSingleton(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

