/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotifiable;

final class NotifiableRegistry<Solution_> {
    private final List<VariableListenerNotifiable<Solution_>> notifiableList = new ArrayList<VariableListenerNotifiable<Solution_>>();
    private final Map<EntityDescriptor<?>, Set<VariableListenerNotifiable<Solution_>>> sourceEntityToNotifiableMap = new LinkedHashMap();
    private final Map<VariableDescriptor<?>, List<VariableListenerNotifiable<Solution_>>> sourceVariableToNotifiableMap = new LinkedHashMap();

    NotifiableRegistry(SolutionDescriptor<Solution_> solutionDescriptor) {
        for (EntityDescriptor<Solution_> entityDescriptor : solutionDescriptor.getEntityDescriptors()) {
            this.sourceEntityToNotifiableMap.put(entityDescriptor, new LinkedHashSet());
            for (VariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                this.sourceVariableToNotifiableMap.put(variableDescriptor, new ArrayList());
            }
        }
    }

    void registerNotifiable(VariableDescriptor<Solution_> source, VariableListenerNotifiable<Solution_> notifiable) {
        this.registerNotifiable(Collections.singletonList(source), notifiable);
    }

    void registerNotifiable(Collection<VariableDescriptor<Solution_>> sources, VariableListenerNotifiable<Solution_> notifiable) {
        for (VariableDescriptor<Solution_> source : sources) {
            this.sourceVariableToNotifiableMap.get(source).add(notifiable);
            this.sourceEntityToNotifiableMap.get(source.getEntityDescriptor()).add(notifiable);
        }
        this.notifiableList.add(notifiable);
    }

    Iterable<VariableListenerNotifiable<Solution_>> getAll() {
        return this.notifiableList;
    }

    Collection<VariableListenerNotifiable<Solution_>> get(EntityDescriptor<?> entityDescriptor) {
        return this.sourceEntityToNotifiableMap.get(entityDescriptor);
    }

    Collection<VariableListenerNotifiable<Solution_>> get(VariableDescriptor<?> variableDescriptor) {
        return this.sourceVariableToNotifiableMap.getOrDefault(variableDescriptor, Collections.emptyList());
    }
}

