/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.optaplanner.core.impl.solver.BestSolutionContainingProblemChanges;
import org.optaplanner.core.impl.solver.BestSolutionHolder;

final class ConsumerSupport<Solution_, ProblemId_>
implements AutoCloseable {
    private final ProblemId_ problemId;
    private final Consumer<? super Solution_> bestSolutionConsumer;
    private final Consumer<? super Solution_> finalBestSolutionConsumer;
    private final BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler;
    private final Semaphore activeConsumption = new Semaphore(1);
    private final BestSolutionHolder<Solution_> bestSolutionHolder;
    private ExecutorService consumerExecutor = Executors.newSingleThreadExecutor();

    public ConsumerSupport(ProblemId_ problemId, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler, BestSolutionHolder<Solution_> bestSolutionHolder) {
        this.problemId = problemId;
        this.bestSolutionConsumer = bestSolutionConsumer;
        this.finalBestSolutionConsumer = finalBestSolutionConsumer == null ? finalBestSolution -> {} : finalBestSolutionConsumer;
        this.exceptionHandler = exceptionHandler;
        this.bestSolutionHolder = bestSolutionHolder;
    }

    void consumeIntermediateBestSolution(Solution_ bestSolution, BooleanSupplier isEveryProblemChangeProcessed) {
        this.bestSolutionHolder.set(bestSolution, isEveryProblemChangeProcessed);
        if (this.bestSolutionConsumer != null) {
            this.tryConsumeWaitingIntermediateBestSolution();
        }
    }

    void consumeFinalBestSolution(Solution_ finalBestSolution) {
        try {
            this.activeConsumption.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted when waiting for the final best solution consumption.");
        }
        if (this.bestSolutionConsumer != null) {
            this.scheduleIntermediateBestSolutionConsumption();
        }
        this.consumerExecutor.submit(() -> {
            try {
                this.finalBestSolutionConsumer.accept(finalBestSolution);
            }
            catch (Throwable throwable) {
                this.exceptionHandler.accept(this.problemId, throwable);
            }
            finally {
                if (this.bestSolutionConsumer == null) {
                    this.bestSolutionHolder.take().completeProblemChanges();
                }
                this.bestSolutionHolder.cancelPendingChanges();
                this.activeConsumption.release();
            }
        });
    }

    private void tryConsumeWaitingIntermediateBestSolution() {
        if (this.bestSolutionHolder.isEmpty()) {
            return;
        }
        if (this.activeConsumption.tryAcquire()) {
            this.scheduleIntermediateBestSolutionConsumption().thenRunAsync(this::tryConsumeWaitingIntermediateBestSolution, this.consumerExecutor);
        }
    }

    private CompletableFuture<Void> scheduleIntermediateBestSolutionConsumption() {
        return CompletableFuture.runAsync(() -> {
            BestSolutionContainingProblemChanges<Solution_> bestSolutionContainingProblemChanges = this.bestSolutionHolder.take();
            if (bestSolutionContainingProblemChanges != null) {
                try {
                    this.bestSolutionConsumer.accept(bestSolutionContainingProblemChanges.getBestSolution());
                    bestSolutionContainingProblemChanges.completeProblemChanges();
                }
                catch (Throwable throwable) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.accept(this.problemId, throwable);
                    }
                    bestSolutionContainingProblemChanges.completeProblemChangesExceptionally(throwable);
                }
                finally {
                    this.activeConsumption.release();
                }
            }
        }, this.consumerExecutor);
    }

    @Override
    public void close() {
        if (this.consumerExecutor != null) {
            this.consumerExecutor.shutdownNow();
            this.consumerExecutor = null;
        }
        this.bestSolutionHolder.cancelPendingChanges();
    }
}

