/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.function.BiFunction;
import org.optaplanner.constraint.streams.bavet.bi.BiTuple;
import org.optaplanner.constraint.streams.bavet.common.AbstractScorer;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.score.Score;

public final class BiScorer<A, B>
extends AbstractScorer {
    private final String constraintPackage;
    private final String constraintName;
    private final Score<?> constraintWeight;
    private final BiFunction<A, B, UndoScoreImpacter> scoreImpacter;
    private final int inputStoreIndex;

    public BiScorer(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, UndoScoreImpacter> scoreImpacter, int inputStoreIndex) {
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintWeight = constraintWeight;
        this.scoreImpacter = scoreImpacter;
        this.inputStoreIndex = inputStoreIndex;
    }

    public void insert(BiTuple<A, B> tupleAB) {
        if (tupleAB.store[this.inputStoreIndex] != null) {
            throw new IllegalStateException("Impossible state: the input for the facts (" + tupleAB.factA + ", " + tupleAB.factB + ") was already added in the tupleStore.");
        }
        UndoScoreImpacter undoScoreImpacter = this.scoreImpacter.apply(tupleAB.factA, tupleAB.factB);
        tupleAB.store[this.inputStoreIndex] = undoScoreImpacter;
    }

    public void retract(BiTuple<A, B> tupleAB) {
        UndoScoreImpacter undoScoreImpacter = (UndoScoreImpacter)tupleAB.store[this.inputStoreIndex];
        if (undoScoreImpacter != null) {
            undoScoreImpacter.run();
            tupleAB.store[this.inputStoreIndex] = null;
        }
    }

    public String toString() {
        return "Scorer(" + this.constraintName + ") with constraintWeight (" + this.constraintWeight + ")";
    }
}

