/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.core.impl.score.stream.JoinerType;

final class ComparisonIndexer<Tuple_ extends Tuple, Value_>
implements Indexer<Tuple_, Value_> {
    private final BiFunction<NavigableMap<Object, Indexer<Tuple_, Value_>>, Comparable, Map<Object, Indexer<Tuple_, Value_>>> submapFunction;
    private final Function<IndexProperties, Comparable> comparisonIndexPropertyFunction;
    private final Supplier<Indexer<Tuple_, Value_>> downstreamIndexerSupplier;
    private final NavigableMap<Object, Indexer<Tuple_, Value_>> comparisonMap = new TreeMap<Object, Indexer<Tuple_, Value_>>();

    public ComparisonIndexer(JoinerType comparisonJoinerType, Function<IndexProperties, Comparable> comparisonIndexPropertyFunction, Supplier<Indexer<Tuple_, Value_>> downstreamIndexerSupplier) {
        this.submapFunction = this.getSubmapFunction(comparisonJoinerType);
        this.comparisonIndexPropertyFunction = Objects.requireNonNull(comparisonIndexPropertyFunction);
        this.downstreamIndexerSupplier = Objects.requireNonNull(downstreamIndexerSupplier);
    }

    @Override
    public void put(IndexProperties indexProperties, Tuple_ tuple, Value_ value) {
        Objects.requireNonNull(value);
        Comparable comparisonIndexProperty = this.comparisonIndexPropertyFunction.apply(indexProperties);
        Indexer downstreamIndexer = this.comparisonMap.computeIfAbsent(comparisonIndexProperty, k -> this.downstreamIndexerSupplier.get());
        downstreamIndexer.put(indexProperties, tuple, value);
    }

    @Override
    public Value_ remove(IndexProperties indexProperties, Tuple_ tuple) {
        Comparable comparisonIndexProperty = this.comparisonIndexPropertyFunction.apply(indexProperties);
        Indexer downstreamIndexer = (Indexer)this.comparisonMap.get(comparisonIndexProperty);
        if (downstreamIndexer == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + indexProperties + ") doesn't exist in the indexer.");
        }
        Object value = downstreamIndexer.remove(indexProperties, tuple);
        if (downstreamIndexer.isEmpty()) {
            this.comparisonMap.remove(comparisonIndexProperty);
        }
        return value;
    }

    private BiFunction<NavigableMap<Object, Indexer<Tuple_, Value_>>, Comparable, Map<Object, Indexer<Tuple_, Value_>>> getSubmapFunction(JoinerType comparisonJoinerType) {
        switch (comparisonJoinerType) {
            case LESS_THAN: {
                return (comparisonMap, comparisonIndexProperty) -> comparisonMap.headMap(comparisonIndexProperty, false);
            }
            case LESS_THAN_OR_EQUAL: {
                return (comparisonMap, comparisonIndexProperty) -> comparisonMap.headMap(comparisonIndexProperty, true);
            }
            case GREATER_THAN: {
                return (comparisonMap, comparisonIndexProperty) -> comparisonMap.tailMap(comparisonIndexProperty, false);
            }
            case GREATER_THAN_OR_EQUAL: {
                return (comparisonMap, comparisonIndexProperty) -> comparisonMap.tailMap(comparisonIndexProperty, true);
            }
        }
        throw new IllegalStateException("Impossible state: the comparisonJoinerType (" + comparisonJoinerType + ") is not one of the 4 comparison types.");
    }

    @Override
    public void visit(IndexProperties indexProperties, BiConsumer<Tuple_, Value_> tupleValueVisitor) {
        Comparable comparisonIndexProperty = this.comparisonIndexPropertyFunction.apply(indexProperties);
        Map<Object, Indexer<Tuple_, Value_>> selectedComparisonMap = this.submapFunction.apply(this.comparisonMap, comparisonIndexProperty);
        if (selectedComparisonMap.isEmpty()) {
            return;
        }
        for (Indexer<Tuple_, Value_> indexer : selectedComparisonMap.values()) {
            indexer.visit(indexProperties, tupleValueVisitor);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.comparisonMap.isEmpty();
    }
}

