/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.index;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.listener.SourcedVariableListener;

public class ExternalizedIndexVariableSupply<Solution_>
implements SourcedVariableListener<Solution_, Object>,
IndexVariableSupply {
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;
    protected Map<Object, Integer> indexMap = null;

    public ExternalizedIndexVariableSupply(ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(ScoreDirector<Solution_> scoreDirector) {
        this.indexMap = new IdentityHashMap<Object, Integer>();
        this.sourceVariableDescriptor.getEntityDescriptor().getSolutionDescriptor().visitAllEntities(scoreDirector.getWorkingSolution(), this::insert);
    }

    @Override
    public void close() {
        this.indexMap = null;
    }

    @Override
    public boolean requiresUniqueEntityEvents() {
        return true;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert(entity);
    }

    @Override
    public void beforeVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.retract(entity);
    }

    @Override
    public void afterVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert(entity);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.retract(entity);
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    private void insert(Object entity) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        int index = 0;
        for (Object value : listVariable) {
            Integer oldIndex = this.indexMap.put(value, index);
            if (oldIndex != null) {
                throw new IllegalStateException("The supply (" + this + ") is corrupted, because the entity (" + entity + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be inserted: one of its values (" + value + ") at index (" + index + ") already has a non-null oldIndex (" + oldIndex + ").");
            }
            ++index;
        }
    }

    private void retract(Object entity) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        int index = 0;
        for (Object value : listVariable) {
            Integer oldIndex = this.indexMap.remove(value);
            if (!Objects.equals(oldIndex, index)) {
                throw new IllegalStateException("The supply (" + this + ") is corrupted, because the entity (" + entity + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be retracted: one of its values (" + value + ") at index (" + index + ") already has an unexpected oldIndex (" + oldIndex + ").");
            }
            ++index;
        }
    }

    @Override
    public Integer getIndex(Object planningValue) {
        return this.indexMap.get(planningValue);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getVariableName() + ")";
    }
}

