/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.ArrayDeque;
import java.util.Collection;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.listener.support.SmallScalingOrderedSet;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotification;

final class VariableListenerNotifiable<Solution_> {
    private final ScoreDirector<Solution_> scoreDirector;
    private final VariableListener<Solution_, Object> variableListener;
    private final int globalOrder;
    private final Collection<VariableListenerNotification> notificationQueue;

    VariableListenerNotifiable(ScoreDirector<Solution_> scoreDirector, VariableListener<Solution_, ?> variableListener, int globalOrder) {
        this.scoreDirector = scoreDirector;
        this.variableListener = variableListener;
        this.globalOrder = globalOrder;
        this.notificationQueue = variableListener.requiresUniqueEntityEvents() ? new SmallScalingOrderedSet<VariableListenerNotification>() : new ArrayDeque<VariableListenerNotification>();
    }

    void resetWorkingSolution() {
        this.variableListener.resetWorkingSolution(this.scoreDirector);
    }

    void closeVariableListener() {
        this.variableListener.close();
    }

    void addNotification(VariableListenerNotification notification) {
        if (this.notificationQueue.add(notification)) {
            notification.triggerBefore(this.variableListener, this.scoreDirector);
        }
    }

    void triggerAllNotifications() {
        int notifiedCount = 0;
        for (VariableListenerNotification notification : this.notificationQueue) {
            notification.triggerAfter(this.variableListener, this.scoreDirector);
            ++notifiedCount;
        }
        if (notifiedCount != this.notificationQueue.size()) {
            throw new IllegalStateException("The variableListener (" + this.variableListener.getClass() + ") has been notified with notifiedCount (" + notifiedCount + ") but after being triggered, its notificationCount (" + this.notificationQueue.size() + ") is different.\nMaybe that variableListener (" + this.variableListener.getClass() + ") changed an upstream shadow variable (which is illegal).");
        }
        this.notificationQueue.clear();
    }

    public String toString() {
        return "(" + this.globalOrder + ") " + this.variableListener;
    }
}

