/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class ListSwapMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object leftEntity;
    private final int leftIndex;
    private final Object rightEntity;
    private final int rightIndex;

    public ListSwapMove(ListVariableDescriptor<Solution_> variableDescriptor, Object leftEntity, int leftIndex, Object rightEntity, int rightIndex) {
        this.variableDescriptor = variableDescriptor;
        this.leftEntity = leftEntity;
        this.leftIndex = leftIndex;
        this.rightEntity = rightEntity;
        this.rightIndex = rightIndex;
    }

    public Object getLeftEntity() {
        return this.leftEntity;
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public Object getRightEntity() {
        return this.rightEntity;
    }

    public int getRightIndex() {
        return this.rightIndex;
    }

    public Object getLeftValue() {
        return this.variableDescriptor.getElement(this.leftEntity, this.leftIndex);
    }

    public Object getRightValue() {
        return this.variableDescriptor.getElement(this.rightEntity, this.rightIndex);
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return this.rightEntity != this.leftEntity || this.leftIndex != this.rightIndex;
    }

    @Override
    public ListSwapMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new ListSwapMove<Solution_>(this.variableDescriptor, this.rightEntity, this.rightIndex, this.leftEntity, this.leftIndex);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object leftElement = this.variableDescriptor.getElement(this.leftEntity, this.leftIndex);
        Object rightElement = this.variableDescriptor.getElement(this.rightEntity, this.rightIndex);
        innerScoreDirector.beforeVariableChanged(this.variableDescriptor, this.leftEntity);
        this.variableDescriptor.setElement(this.leftEntity, this.leftIndex, rightElement);
        if (this.leftEntity != this.rightEntity) {
            innerScoreDirector.afterVariableChanged(this.variableDescriptor, this.leftEntity);
            innerScoreDirector.beforeVariableChanged(this.variableDescriptor, this.rightEntity);
        }
        this.variableDescriptor.setElement(this.rightEntity, this.rightIndex, leftElement);
        innerScoreDirector.afterVariableChanged(this.variableDescriptor, this.rightEntity);
    }

    @Override
    public ListSwapMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new ListSwapMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.leftEntity), this.leftIndex, destinationScoreDirector.lookUpWorkingObject(this.rightEntity), this.rightIndex);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<Object> getPlanningEntities() {
        LinkedHashSet<Object> entities = new LinkedHashSet<Object>(2);
        entities.add(this.leftEntity);
        entities.add(this.rightEntity);
        return entities;
    }

    @Override
    public Collection<Object> getPlanningValues() {
        return Arrays.asList(this.getLeftValue(), this.getRightValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListSwapMove other = (ListSwapMove)o;
        return this.leftIndex == other.leftIndex && this.rightIndex == other.rightIndex && Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.leftEntity, other.leftEntity) && Objects.equals(this.rightEntity, other.rightEntity);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.leftEntity, this.leftIndex, this.rightEntity, this.rightIndex);
    }

    public String toString() {
        return String.format("%s {%s[%d]} <-> %s {%s[%d]}", this.getLeftValue(), this.leftEntity, this.leftIndex, this.getRightValue(), this.rightEntity, this.rightIndex);
    }
}

