/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.examination.domain.Student;

@XStreamAlias(value="Topic")
public class Topic
extends AbstractPersistable {
    private int duration;
    private Set<Student> studentSet;
    private boolean frontLoadLarge;
    private Set<Topic> coincidenceTopicSet = null;

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public Set<Student> getStudentSet() {
        return this.studentSet;
    }

    public void setStudentSet(Set<Student> studentSet) {
        this.studentSet = studentSet;
    }

    public int getStudentSize() {
        return this.studentSet.size();
    }

    public boolean isFrontLoadLarge() {
        return this.frontLoadLarge;
    }

    public void setFrontLoadLarge(boolean frontLoadLarge) {
        this.frontLoadLarge = frontLoadLarge;
    }

    public Set<Topic> getCoincidenceTopicSet() {
        return this.coincidenceTopicSet;
    }

    public void setCoincidenceTopicSet(Set<Topic> coincidenceTopicSet) {
        this.coincidenceTopicSet = coincidenceTopicSet;
    }

    public boolean hasCoincidenceTopic() {
        return this.coincidenceTopicSet != null;
    }

    @Override
    public String toString() {
        return this.id == null ? "no id" : Long.toString(this.id);
    }

    public Topic withId(long id) {
        this.setId(id);
        return this;
    }

    public Topic withDuration(int duration) {
        this.setDuration(duration);
        return this;
    }

    public Topic withStudents(Student ... students) {
        this.setStudentSet(Arrays.stream(students).collect(Collectors.toSet()));
        return this;
    }

    public Topic withFrontLoadLarge(boolean frontLoadLarge) {
        this.setFrontLoadLarge(frontLoadLarge);
        return this;
    }

    public Topic withCoincidenceTopicSet(Set<Topic> coincidenceTopicSet) {
        this.setCoincidenceTopicSet(coincidenceTopicSet);
        return this;
    }
}

