/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.drools.util.ClassUtils;
import org.kie.api.definition.type.Modifies;

public class PropertyReactivityUtil {
    public static List<String> getAccessibleProperties(Class<?> clazz) {
        TreeSet<PropertyInClass> props = new TreeSet<PropertyInClass>();
        for (Method method : clazz.getMethods()) {
            String propName;
            if (method.getParameterTypes().length == 0 && (propName = ClassUtils.getter2property((String)method.getName())) != null && !propName.equals("class")) {
                props.add(new PropertyInClass(propName, method.getDeclaringClass()));
            }
            PropertyReactivityUtil.processModifiesAnnotation(clazz, props, method);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (!Modifier.isPublic(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            props.add(new PropertyInClass(((Field)accessibleObject).getName(), ((Field)accessibleObject).getDeclaringClass()));
        }
        ArrayList<String> accessibleProperties = new ArrayList<String>();
        for (PropertyInClass setter : props) {
            accessibleProperties.add(setter.setter);
        }
        return accessibleProperties;
    }

    private static void processModifiesAnnotation(Class<?> clazz, Set<PropertyInClass> props, Method m) {
        Modifies modifies = m.getAnnotation(Modifies.class);
        if (modifies != null) {
            for (String prop : modifies.value()) {
                prop = prop.trim();
                try {
                    Field field = clazz.getField(prop);
                    props.add(new PropertyInClass(field.getName(), field.getDeclaringClass()));
                }
                catch (NoSuchFieldException e) {
                    String getter = "get" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
                    try {
                        Method method = clazz.getMethod(getter, new Class[0]);
                        props.add(new PropertyInClass(prop, method.getDeclaringClass()));
                    }
                    catch (NoSuchMethodException e1) {
                        getter = "is" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
                        try {
                            Method method = clazz.getMethod(getter, new Class[0]);
                            props.add(new PropertyInClass(prop, method.getDeclaringClass()));
                        }
                        catch (NoSuchMethodException e2) {
                            throw new RuntimeException(e2);
                        }
                    }
                }
            }
        }
    }

    private static class PropertyInClass
    implements Comparable {
        private final String setter;
        private final Class<?> clazz;

        private PropertyInClass(String setter, Class<?> clazz) {
            this.setter = setter;
            this.clazz = clazz;
        }

        public int compareTo(Object o) {
            PropertyInClass other = (PropertyInClass)o;
            if (this.clazz == other.clazz) {
                return this.setter.compareTo(other.setter);
            }
            return this.clazz.isAssignableFrom(other.clazz) ? -1 : 1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PropertyInClass)) {
                return false;
            }
            PropertyInClass other = (PropertyInClass)obj;
            return this.clazz == other.clazz && this.setter.equals(other.setter);
        }

        public int hashCode() {
            return 29 * this.clazz.hashCode() + 31 * this.setter.hashCode();
        }
    }
}

