/*
 * Decompiled with CFR 0.152.
 */
package org.drools.wiring.api.classloader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.drools.util.ClassUtils;
import org.drools.wiring.api.ComponentsFactory;
import org.drools.wiring.api.ResourceProvider;
import org.kie.internal.utils.KieTypeResolver;
import org.kie.memorycompiler.StoreClassLoader;
import org.kie.memorycompiler.WritableClassLoader;

public abstract class ProjectClassLoader
extends ClassLoader
implements KieTypeResolver,
StoreClassLoader,
WritableClassLoader {
    private static final boolean CACHE_NON_EXISTING_CLASSES = true;
    private static final ClassNotFoundException dummyCFNE = new ClassNotFoundException("This is just a cached Exception. Disable non existing classes cache to see the actual one.");
    private static boolean enableStoreFirst = Boolean.valueOf(System.getProperty("drools.projectClassLoader.enableStoreFirst", "true"));
    private Map<String, byte[]> store;
    private Map<String, ClassBytecode> definedTypes;
    private final Set<String> nonExistingClasses = ConcurrentHashMap.newKeySet();
    private ClassLoader droolsClassLoader;
    private InternalTypesClassLoader typesClassLoader;
    private final Map<String, Class<?>> loadedClasses = new ConcurrentHashMap();
    protected Set<String> generatedClassNames = new HashSet<String>();
    private ResourceProvider resourceProvider;

    protected ProjectClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
        super(parent);
        this.resourceProvider = resourceProvider;
    }

    public static ClassLoader getClassLoader(ClassLoader classLoader, Class<?> cls) {
        ProjectClassLoader projectClassLoader = ProjectClassLoader.createProjectClassLoader(classLoader);
        if (cls != null) {
            projectClassLoader.setDroolsClassLoader(cls.getClassLoader());
        }
        return projectClassLoader;
    }

    public ClassLoader getTypesClassLoader() {
        return this.typesClassLoader instanceof ClassLoader ? (ClassLoader)((Object)this.typesClassLoader) : this;
    }

    public static ProjectClassLoader createProjectClassLoader() {
        return ComponentsFactory.createProjectClassLoader(ClassUtils.findParentClassLoader(ProjectClassLoader.class), null);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent) {
        return ProjectClassLoader.createProjectClassLoader(parent, (ResourceProvider)null);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
        if (parent == null) {
            return ComponentsFactory.createProjectClassLoader(ClassUtils.findParentClassLoader(ProjectClassLoader.class), resourceProvider);
        }
        return parent instanceof ProjectClassLoader ? (ProjectClassLoader)parent : ComponentsFactory.createProjectClassLoader(parent, resourceProvider);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent, Map<String, byte[]> store) {
        ProjectClassLoader projectClassLoader = ProjectClassLoader.createProjectClassLoader(parent);
        projectClassLoader.store = store;
        return projectClassLoader;
    }

    public abstract boolean isDynamic();

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.loadedClasses.get(name);
        if (cls != null) {
            return cls;
        }
        if (this.isStoreFirst(name)) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz != null) {
                return clazz;
            }
            if (this.typesClassLoader != null && (clazz = this.typesClassLoader.findLoadedClassWithoutParent(name)) != null) {
                return clazz;
            }
            cls = this.tryDefineType(name, null);
        } else {
            try {
                cls = this.internalLoadClass(name, resolve);
            }
            catch (ClassNotFoundException e2) {
                cls = this.loadType(name, resolve);
            }
        }
        this.loadedClasses.put(name, cls);
        return cls;
    }

    protected boolean isStoreFirst(String name) {
        return false;
    }

    public Class<?> internalLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.nonExistingClasses.contains(name)) {
            throw dummyCFNE;
        }
        if (this.droolsClassLoader != null) {
            try {
                return Class.forName(name, resolve, this.droolsClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(name, resolve, this.getParent());
            }
            catch (ClassNotFoundException e1) {
                this.nonExistingClasses.add(name);
                throw e1;
            }
        }
    }

    private Class<?> loadType(String name, boolean resolve) throws ClassNotFoundException {
        ClassNotFoundException cnfe = null;
        if (this.typesClassLoader != null) {
            try {
                return this.typesClassLoader.loadType(name, resolve);
            }
            catch (ClassNotFoundException e) {
                cnfe = e;
            }
        }
        return this.tryDefineType(name, cnfe);
    }

    public Class<?> tryDefineType(String name, ClassNotFoundException cnfe) throws ClassNotFoundException {
        byte[] bytecode = this.getBytecode(org.drools.wiring.api.util.ClassUtils.convertClassToResourcePath(name));
        if (bytecode == null) {
            this.nonExistingClasses.add(name);
            throw cnfe != null ? cnfe : new ClassNotFoundException(name);
        }
        return this.defineType(name, bytecode);
    }

    private synchronized Class<?> defineType(String name, byte[] bytecode) {
        if (this.definedTypes == null) {
            this.definedTypes = new HashMap<String, ClassBytecode>();
        } else {
            ClassBytecode existingClass = this.definedTypes.get(name);
            if (existingClass != null && Arrays.equals(bytecode, existingClass.bytes)) {
                return existingClass.clazz;
            }
        }
        if (this.typesClassLoader == null) {
            this.typesClassLoader = this.makeClassLoader();
        }
        Class<?> clazz = this.typesClassLoader.defineClass(name, bytecode);
        this.definedTypes.put(name, new ClassBytecode(clazz, bytecode));
        this.loadedClasses.put(name, clazz);
        return clazz;
    }

    public Class<?> writeClass(String name, byte[] bytecode) {
        return this.defineClass(name, bytecode, 0, bytecode.length);
    }

    public Class<?> defineClass(String name, byte[] bytecode) {
        return this.defineClass(name, org.drools.wiring.api.util.ClassUtils.convertClassToResourcePath(name), bytecode);
    }

    public synchronized Class<?> defineClass(String name, String resourceName, byte[] bytecode) {
        this.storeClass(name, resourceName, bytecode);
        return this.defineType(name, bytecode);
    }

    public synchronized void undefineClass(String name) {
        String resourceName = org.drools.wiring.api.util.ClassUtils.convertClassToResourcePath(name);
        if (this.store.remove(resourceName) != null) {
            this.nonExistingClasses.add(name);
            this.typesClassLoader = null;
        }
    }

    public void storeClass(String name, byte[] bytecode) {
        this.storeClass(name, org.drools.wiring.api.util.ClassUtils.convertClassToResourcePath(name), bytecode);
    }

    public void storeClasses(Map<String, byte[]> classesMap) {
        for (Map.Entry<String, byte[]> entry : classesMap.entrySet()) {
            if (entry.getValue() == null) continue;
            String resourceName = entry.getKey();
            String className = org.drools.wiring.api.util.ClassUtils.convertResourceToClassName(resourceName);
            this.storeClass(className, resourceName, entry.getValue());
        }
    }

    public void storeClass(String name, String resourceName, byte[] bytecode) {
        if (this.store == null) {
            this.store = new HashMap<String, byte[]>();
        }
        this.store.put(resourceName, bytecode);
        this.nonExistingClasses.remove(name);
    }

    public boolean isClassInUse(String className, Class<? extends Annotation> annotationClazz) {
        boolean clazzFound;
        Class<?> clazz = this.loadedClasses.get(className);
        boolean bl = clazzFound = clazz != null;
        if (annotationClazz != null) {
            return clazzFound && !clazz.isAnnotationPresent(annotationClazz);
        }
        return clazzFound;
    }

    public boolean isClassInUse(String className) {
        return this.loadedClasses.containsKey(className);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytecode = this.getBytecode(name);
        if (bytecode != null) {
            return new ByteArrayInputStream(bytecode);
        }
        if (this.resourceProvider != null) {
            try {
                InputStream is = this.resourceProvider.getResourceAsStream(name);
                if (is != null) {
                    return is;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource;
        if (this.droolsClassLoader != null && (resource = this.droolsClassLoader.getResource(name)) != null) {
            return resource;
        }
        if (this.resourceProvider != null && (resource = this.resourceProvider.getResource(name)) != null) {
            return resource;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = super.getResources(name);
        if (this.resourceProvider != null) {
            URL providedResource = this.resourceProvider.getResource(name);
            if (resources != null) {
                return new ResourcesEnum(providedResource, resources);
            }
        }
        return resources;
    }

    public Set<String> getGeneratedClassNames() {
        return this.generatedClassNames;
    }

    public void setGeneratedClassNames(Set<String> generatedClassNames) {
        this.generatedClassNames = generatedClassNames;
    }

    public static boolean isEnableStoreFirst() {
        return enableStoreFirst;
    }

    static void setEnableStoreFirst(boolean enableStoreFirst) {
        ProjectClassLoader.enableStoreFirst = enableStoreFirst;
    }

    public byte[] getBytecode(String resourceName) {
        return this.store == null ? null : this.store.get(resourceName);
    }

    public Map<String, byte[]> getStore() {
        return this.store;
    }

    public void clearStore() {
        if (this.store != null) {
            this.store.clear();
        }
    }

    public void setDroolsClassLoader(ClassLoader droolsClassLoader) {
        if (this.getParent() != droolsClassLoader && ProjectClassLoader.isModularClassLoader(droolsClassLoader)) {
            this.droolsClassLoader = droolsClassLoader;
            this.nonExistingClasses.clear();
        }
    }

    private static boolean isModularClassLoader(ClassLoader cl) {
        return ProjectClassLoader.isOsgiClassLoader(cl) || ProjectClassLoader.isJbossModuleClassLoader(cl);
    }

    private static boolean isJbossModuleClassLoader(ClassLoader cl) {
        return "org.jboss.modules".equals(cl.getClass().getPackage().getName());
    }

    private static boolean isOsgiClassLoader(ClassLoader cl) {
        for (Class<?> clc = cl.getClass(); clc != null && !clc.equals(ClassLoader.class); clc = clc.getSuperclass()) {
            if (!Stream.of(clc.getInterfaces()).map(Class::getSimpleName).anyMatch(name -> name.equals("BundleReference"))) continue;
            return true;
        }
        return false;
    }

    public void setInternalClassLoader(InternalTypesClassLoader classLoader) {
        this.typesClassLoader = classLoader;
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    public void initFrom(ProjectClassLoader other) {
        if (other.store != null) {
            if (this.store == null) {
                this.store = new HashMap<String, byte[]>();
            }
            this.store.putAll(other.store);
        }
        this.nonExistingClasses.addAll(other.nonExistingClasses);
    }

    public abstract InternalTypesClassLoader makeClassLoader();

    public synchronized List<String> reinitTypes() {
        this.typesClassLoader = null;
        this.nonExistingClasses.clear();
        this.loadedClasses.clear();
        if (this.definedTypes != null) {
            ArrayList<String> removedTypes = new ArrayList<String>(this.definedTypes.keySet());
            this.definedTypes.clear();
            return removedTypes;
        }
        return Collections.emptyList();
    }

    static {
        ProjectClassLoader.registerAsParallelCapable();
    }

    private static class ClassBytecode {
        private final Class<?> clazz;
        private final byte[] bytes;

        private ClassBytecode(Class<?> clazz, byte[] bytes) {
            this.clazz = clazz;
            this.bytes = bytes;
        }
    }

    public static interface InternalTypesClassLoader
    extends KieTypeResolver {
        public Class<?> defineClass(String var1, byte[] var2);

        public Class<?> loadType(String var1, boolean var2) throws ClassNotFoundException;

        default public Class<?> findLoadedClassWithoutParent(String name) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ResourcesEnum
    implements Enumeration<URL> {
        private URL providedResource;
        private final Enumeration<URL> resources;

        private ResourcesEnum(URL providedResource, Enumeration<URL> resources) {
            this.providedResource = providedResource;
            this.resources = resources;
        }

        @Override
        public boolean hasMoreElements() {
            return this.providedResource != null || this.resources.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            if (this.providedResource != null) {
                URL result = this.providedResource;
                this.providedResource = null;
                return result;
            }
            return this.resources.nextElement();
        }
    }
}

