/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.BiTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetFilterBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B> {
    private final BavetAbstractBiConstraintStream<Solution_, A, B> parent;
    private final BiPredicate<A, B> predicate;

    public BavetFilterBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BiPredicate<A, B> predicate) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        this.predicate = predicate;
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate (null) cannot be null.");
        }
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this.parent.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        Consumer insert = buildHelper.getAggregatedInsert(this.childStreamList);
        Consumer retract = buildHelper.getAggregatedRetract(this.childStreamList);
        buildHelper.putInsertRetract(this, new ConditionalBiConsumer<A, B>(this.predicate, insert), retract);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.predicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFilterBiConstraintStream) {
            BavetFilterBiConstraintStream other = (BavetFilterBiConstraintStream)o;
            return this.parent == other.parent && this.predicate == other.predicate;
        }
        return false;
    }

    public String toString() {
        return "Filter() with " + this.childStreamList.size() + " children";
    }

    private static final class ConditionalBiConsumer<A, B>
    implements Consumer<BiTuple<A, B>> {
        private final BiPredicate<A, B> predicate;
        private final Consumer<BiTuple<A, B>> consumer;

        public ConditionalBiConsumer(BiPredicate<A, B> predicate, Consumer<BiTuple<A, B>> consumer) {
            this.predicate = predicate;
            this.consumer = consumer;
        }

        @Override
        public void accept(BiTuple<A, B> tuple) {
            if (this.predicate.test(tuple.factA, tuple.factB)) {
                this.consumer.accept(tuple);
            }
        }
    }
}

