/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public final class IfExistsUniWithUniNode<A, B>
extends AbstractNode {
    private final boolean shouldExist;
    private final Function<A, IndexProperties> mappingA;
    private final Function<B, IndexProperties> mappingB;
    private final int inputStoreIndexA;
    private final int inputStoreIndexB;
    private final Consumer<UniTuple<A>> nextNodesInsert;
    private final Consumer<UniTuple<A>> nextNodesRetract;
    private final Indexer<UniTuple<A>, Counter<A>> indexerA;
    private final Indexer<UniTuple<B>, Set<Counter<A>>> indexerB;
    private final BiPredicate<A, B> filtering;
    private final Queue<Counter<A>> dirtyCounterQueue;

    public IfExistsUniWithUniNode(boolean shouldExist, Function<A, IndexProperties> mappingA, Function<B, IndexProperties> mappingB, int inputStoreIndexA, int inputStoreIndexB, Consumer<UniTuple<A>> nextNodesInsert, Consumer<UniTuple<A>> nextNodesRetract, Indexer<UniTuple<A>, Counter<A>> indexerA, Indexer<UniTuple<B>, Set<Counter<A>>> indexerB, BiPredicate<A, B> filtering) {
        this.shouldExist = shouldExist;
        this.mappingA = mappingA;
        this.mappingB = mappingB;
        this.inputStoreIndexA = inputStoreIndexA;
        this.inputStoreIndexB = inputStoreIndexB;
        this.nextNodesInsert = nextNodesInsert;
        this.nextNodesRetract = nextNodesRetract;
        this.indexerA = indexerA;
        this.indexerB = indexerB;
        this.filtering = filtering;
        this.dirtyCounterQueue = new ArrayDeque<Counter<A>>(1000);
    }

    public void insertA(UniTuple<A> tupleA) {
        if (tupleA.store[this.inputStoreIndexA] != null) {
            throw new IllegalStateException("Impossible state: the input for the fact (" + tupleA.factA + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingA.apply(tupleA.factA);
        tupleA.store[this.inputStoreIndexA] = indexProperties;
        Counter<A> counter = new Counter<A>(tupleA);
        this.indexerA.put(indexProperties, tupleA, counter);
        counter.countB = 0;
        this.indexerB.visit(indexProperties, (tupleB, counterSetB) -> {
            if (this.filtering == null || this.filtering.test(tupleA.factA, tupleB.factA)) {
                ++counter.countB;
                counterSetB.add(counter);
            }
        });
        if (this.shouldExist ? counter.countB > 0 : counter.countB == 0) {
            counter.state = BavetTupleState.CREATING;
            this.dirtyCounterQueue.add(counter);
        }
    }

    public void retractA(UniTuple<A> tupleA) {
        IndexProperties indexProperties = (IndexProperties)tupleA.store[this.inputStoreIndexA];
        if (indexProperties == null) {
            return;
        }
        tupleA.store[this.inputStoreIndexA] = null;
        Counter<A> counter = this.indexerA.remove(indexProperties, tupleA);
        this.indexerB.visit(indexProperties, (tupleB, counterSet) -> {
            boolean changed = counterSet.remove(counter);
            if (!changed && this.filtering == null) {
                throw new IllegalStateException("Impossible state: the fact (" + tupleA.factA + ") with indexProperties (" + indexProperties + ") has a counter on the A side that doesn't exist on the B side.");
            }
        });
        if (this.shouldExist ? counter.countB > 0 : counter.countB == 0) {
            this.retractCounter(counter);
        }
    }

    public void insertB(UniTuple<B> tupleB) {
        if (tupleB.store[this.inputStoreIndexB] != null) {
            throw new IllegalStateException("Impossible state: the input for the fact (" + tupleB.factA + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingB.apply(tupleB.factA);
        tupleB.store[this.inputStoreIndexB] = indexProperties;
        LinkedHashSet counterSetB = new LinkedHashSet();
        this.indexerB.put(indexProperties, tupleB, counterSetB);
        this.indexerA.visit(indexProperties, (tupleA, counter) -> {
            if (this.filtering == null || this.filtering.test(tupleA.factA, tupleB.factA)) {
                if (counter.countB == 0) {
                    if (this.shouldExist) {
                        this.insertCounter((Counter<A>)counter);
                    } else {
                        this.retractCounter((Counter<A>)counter);
                    }
                }
                ++counter.countB;
                counterSetB.add(counter);
            }
        });
    }

    public void retractB(UniTuple<B> tupleB) {
        IndexProperties indexProperties = (IndexProperties)tupleB.store[this.inputStoreIndexB];
        if (indexProperties == null) {
            return;
        }
        tupleB.store[this.inputStoreIndexB] = null;
        Set<Counter<A>> counterSetB = this.indexerB.remove(indexProperties, tupleB);
        for (Counter<A> counter : counterSetB) {
            --counter.countB;
            if (counter.countB != 0) continue;
            if (this.shouldExist) {
                this.retractCounter(counter);
                continue;
            }
            this.insertCounter(counter);
        }
    }

    private void insertCounter(Counter<A> counter) {
        switch (counter.state) {
            case DYING: {
                counter.state = BavetTupleState.UPDATING;
                break;
            }
            case DEAD: {
                counter.state = BavetTupleState.CREATING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            case ABORTING: {
                counter.state = BavetTupleState.CREATING;
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: the counter (" + counter + ") has an impossible insert state (" + counter.state + ").");
            }
        }
    }

    private void retractCounter(Counter<A> counter) {
        switch (counter.state) {
            case CREATING: {
                counter.state = BavetTupleState.ABORTING;
                break;
            }
            case UPDATING: {
                counter.state = BavetTupleState.DYING;
                break;
            }
            case OK: {
                counter.state = BavetTupleState.DYING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The counter (" + counter + ") has an impossible retract state (" + counter.state + ").");
            }
        }
    }

    @Override
    public void calculateScore() {
        this.dirtyCounterQueue.forEach(counter -> {
            switch (counter.state) {
                case CREATING: {
                    this.nextNodesInsert.accept(counter.tuple);
                    counter.state = BavetTupleState.OK;
                    break;
                }
                case UPDATING: {
                    this.nextNodesRetract.accept(counter.tuple);
                    this.nextNodesInsert.accept(counter.tuple);
                    counter.state = BavetTupleState.OK;
                    break;
                }
                case DYING: {
                    this.nextNodesRetract.accept(counter.tuple);
                    counter.state = BavetTupleState.DEAD;
                    break;
                }
                case ABORTING: {
                    counter.state = BavetTupleState.DEAD;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: The dirty counter (" + counter + ") has an non-dirty state (" + counter.state + ").");
                }
            }
        });
        this.dirtyCounterQueue.clear();
    }

    public String toString() {
        return "IfExistsUniWithUniNode";
    }

    protected static class Counter<A> {
        public UniTuple<A> tuple;
        public BavetTupleState state = BavetTupleState.DEAD;
        public int countB = 0;

        public Counter(UniTuple<A> tuple) {
            this.tuple = tuple;
        }

        public String toString() {
            return "Counter(" + this.tuple + ")";
        }
    }
}

