/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.lookup;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;

public class ClassAndPlanningIdComparator
implements Comparator<Object> {
    private DomainAccessType domainAccessType;
    private Map<String, MemberAccessor> generatedMemberAccessorMap;
    private boolean failFastIfNoPlanningId;
    private Map<Class, MemberAccessor> decisionCache = new HashMap<Class, MemberAccessor>();

    public ClassAndPlanningIdComparator() {
        this(DomainAccessType.REFLECTION, new HashMap<String, MemberAccessor>(), true);
    }

    public ClassAndPlanningIdComparator(boolean failFastIfNoPlanningId) {
        this(DomainAccessType.REFLECTION, new HashMap<String, MemberAccessor>(), failFastIfNoPlanningId);
    }

    public ClassAndPlanningIdComparator(DomainAccessType domainAccessType, Map<String, MemberAccessor> generatedMemberAccessorMap, boolean failFastIfNoPlanningId) {
        this.domainAccessType = domainAccessType;
        this.generatedMemberAccessorMap = generatedMemberAccessorMap;
        this.failFastIfNoPlanningId = failFastIfNoPlanningId;
    }

    @Override
    public int compare(Object a, Object b) {
        Class<?> bClass;
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        Class<?> aClass = a.getClass();
        if (aClass != (bClass = b.getClass())) {
            return aClass.getName().compareTo(bClass.getName());
        }
        MemberAccessor aMemberAccessor = this.decisionCache.computeIfAbsent(aClass, clazz -> ConfigUtils.findPlanningIdMemberAccessor(clazz, this.domainAccessType, this.generatedMemberAccessorMap));
        MemberAccessor bMemberAccessor = this.decisionCache.computeIfAbsent(bClass, clazz -> ConfigUtils.findPlanningIdMemberAccessor(clazz, this.domainAccessType, this.generatedMemberAccessorMap));
        if (this.failFastIfNoPlanningId) {
            if (aMemberAccessor == null) {
                throw new IllegalArgumentException("The class (" + aClass + ") does not have a @" + PlanningId.class.getSimpleName() + " annotation.\nMaybe add the @" + PlanningId.class.getSimpleName() + " annotation.");
            }
            if (bMemberAccessor == null) {
                throw new IllegalArgumentException("The class (" + bClass + ") does not have a @" + PlanningId.class.getSimpleName() + " annotation.\nMaybe add the @" + PlanningId.class.getSimpleName() + " annotation.");
            }
        } else {
            if (aMemberAccessor == null) {
                if (bMemberAccessor == null) {
                    if (a instanceof Comparable) {
                        return ((Comparable)a).compareTo(b);
                    }
                    return 0;
                }
                return -1;
            }
            if (bMemberAccessor == null) {
                return 1;
            }
        }
        Comparable aPlanningId = (Comparable)aMemberAccessor.executeGetter(a);
        Comparable bPlanningId = (Comparable)bMemberAccessor.executeGetter(b);
        if (aPlanningId == null) {
            throw new IllegalArgumentException("The planningId (" + aPlanningId + ") of the member (" + aMemberAccessor + ") of the class (" + aClass + ") on object (" + a + ") must not be null.\nMaybe initialize the planningId of the original object before solving..");
        }
        if (bPlanningId == null) {
            throw new IllegalArgumentException("The planningId (" + bPlanningId + ") of the member (" + bMemberAccessor + ") of the class (" + bClass + ") on object (" + a + ") must not be null.\nMaybe initialize the planningId of the original object before solving..");
        }
        return aPlanningId.compareTo(bPlanningId);
    }
}

