/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.composite;

import java.util.HashMap;
import java.util.List;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.FixedSelectorProbabilityWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.composite.AbstractCompositeMoveSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.composite.UnionMoveSelector;

public class UnionMoveSelectorFactory<Solution_>
extends AbstractCompositeMoveSelectorFactory<Solution_, UnionMoveSelectorConfig> {
    public UnionMoveSelectorFactory(UnionMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    public MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        FixedSelectorProbabilityWeightFactory selectorProbabilityWeightFactory;
        List<MoveSelector<Solution_>> moveSelectorList = this.buildInnerMoveSelectors(((UnionMoveSelectorConfig)this.config).getMoveSelectorList(), configPolicy, minimumCacheType, randomSelection);
        if (((UnionMoveSelectorConfig)this.config).getSelectorProbabilityWeightFactoryClass() != null) {
            if (!randomSelection) {
                throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") with selectorProbabilityWeightFactoryClass (" + ((UnionMoveSelectorConfig)this.config).getSelectorProbabilityWeightFactoryClass() + ") has non-random randomSelection (" + randomSelection + ").");
            }
            selectorProbabilityWeightFactory = ConfigUtils.newInstance(this.config, "selectorProbabilityWeightFactoryClass", ((UnionMoveSelectorConfig)this.config).getSelectorProbabilityWeightFactoryClass());
        } else if (randomSelection) {
            HashMap<MoveSelector<Solution_>, Double> fixedProbabilityWeightMap = new HashMap<MoveSelector<Solution_>, Double>(((UnionMoveSelectorConfig)this.config).getMoveSelectorList().size());
            for (int i = 0; i < ((UnionMoveSelectorConfig)this.config).getMoveSelectorList().size(); ++i) {
                MoveSelectorConfig innerMoveSelectorConfig = ((UnionMoveSelectorConfig)this.config).getMoveSelectorList().get(i);
                MoveSelector<Solution_> moveSelector = moveSelectorList.get(i);
                Double fixedProbabilityWeight = innerMoveSelectorConfig.getFixedProbabilityWeight();
                if (fixedProbabilityWeight == null) {
                    fixedProbabilityWeight = 1.0;
                }
                fixedProbabilityWeightMap.put(moveSelector, fixedProbabilityWeight);
            }
            selectorProbabilityWeightFactory = new FixedSelectorProbabilityWeightFactory(fixedProbabilityWeightMap);
        } else {
            selectorProbabilityWeightFactory = null;
        }
        return new UnionMoveSelector<Solution_>(moveSelectorList, randomSelection, selectorProbabilityWeightFactory);
    }
}

