/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.testgen;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.kie.api.runtime.KieSession;
import org.optaplanner.constraint.drl.DrlScoreDirector;
import org.optaplanner.constraint.drl.DrlScoreDirectorFactory;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolder;
import org.optaplanner.constraint.drl.testgen.TestGenKieSessionJournal;
import org.optaplanner.constraint.drl.testgen.TestGenTestWriter;
import org.optaplanner.constraint.drl.testgen.TestGenerator;
import org.optaplanner.constraint.drl.testgen.reproducer.TestGenCorruptedScoreException;
import org.optaplanner.constraint.drl.testgen.reproducer.TestGenCorruptedScoreReproducer;
import org.optaplanner.constraint.drl.testgen.reproducer.TestGenCorruptedVariableListenerReproducer;
import org.optaplanner.constraint.drl.testgen.reproducer.TestGenDroolsExceptionReproducer;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class TestGenDrlScoreDirector<Solution_, Score_ extends Score<Score_>>
extends DrlScoreDirector<Solution_, Score_> {
    private static final String TEST_CLASS_NAME = "DroolsReproducerTest";
    private final TestGenKieSessionJournal journal = new TestGenKieSessionJournal();
    private final File testFile = new File("DroolsReproducerTest.java");
    private final TestGenTestWriter writer = new TestGenTestWriter();
    private final Deque<String> oldValues = new ArrayDeque<String>();

    public TestGenDrlScoreDirector(DrlScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference, List<String> scoreDrlList, List<File> scoreDrlFileList) {
        super(scoreDirectorFactory, lookUpEnabled, constraintMatchEnabledPreference);
        this.writer.setClassName(TEST_CLASS_NAME);
        this.writer.setScoreDefinition(scoreDirectorFactory.getScoreDefinition());
        this.writer.setConstraintMatchEnabled(constraintMatchEnabledPreference);
        this.writer.setScoreDrlList(scoreDrlList);
        this.writer.setScoreDrlFileList(scoreDrlFileList);
    }

    public KieSession createKieSession() {
        KieSession newKieSession = ((DrlScoreDirectorFactory)this.getScoreDirectorFactory()).newKieSession();
        ScoreDefinition scoreDefinition = this.getScoreDefinition();
        if (scoreDefinition != null) {
            Object sh = AbstractScoreHolder.buildScoreHolder(scoreDefinition, this.constraintMatchEnabledPreference);
            newKieSession.setGlobal("scoreHolder", sh);
        }
        return newKieSession;
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.journal.dispose();
        Collection workingFacts = this.getSolutionDescriptor().getAllFacts(workingSolution);
        this.journal.addFacts(workingFacts);
        for (Object fact : workingFacts) {
            this.journal.insertInitial(fact);
        }
    }

    @Override
    public Score_ calculateScore() {
        this.journal.fireAllRules();
        try {
            return super.calculateScore();
        }
        catch (RuntimeException e) {
            TestGenDroolsExceptionReproducer reproducer = new TestGenDroolsExceptionReproducer(e, this);
            TestGenKieSessionJournal minJournal = TestGenerator.minimize(this.journal, reproducer);
            this.writer.print(minJournal, this.testFile);
            throw this.wrapOriginalException(e);
        }
    }

    public void assertShadowVariablesAreNotStale(Score_ expectedWorkingScore, Object completedAction) {
        try {
            this.journal.enterAssertMode();
            super.assertShadowVariablesAreNotStale(expectedWorkingScore, completedAction);
            this.journal.exitAssertMode();
        }
        catch (IllegalStateException e) {
            if (e.getMessage().startsWith("Impossible")) {
                TestGenCorruptedVariableListenerReproducer reproducer = new TestGenCorruptedVariableListenerReproducer(e.getMessage(), this);
                TestGenKieSessionJournal minJournal = TestGenerator.minimize(this.journal, reproducer);
                try {
                    minJournal.replay(this.createKieSession());
                    throw new IllegalStateException();
                }
                catch (TestGenCorruptedScoreException tgcse) {
                    this.writer.setCorruptedScoreException(tgcse);
                    this.writer.print(minJournal, this.testFile);
                    throw this.wrapOriginalException(e);
                }
            }
            throw new UnsupportedOperationException("Stale shadow variable reproducer not implemented.", e);
        }
    }

    public void assertWorkingScoreFromScratch(Score_ workingScore, Object completedAction) {
        try {
            super.assertWorkingScoreFromScratch(workingScore, completedAction);
        }
        catch (IllegalStateException e) {
            TestGenCorruptedScoreReproducer reproducer = new TestGenCorruptedScoreReproducer(e.getMessage(), this);
            TestGenKieSessionJournal minJournal = TestGenerator.minimize(this.journal, reproducer);
            try {
                minJournal.replay(this.createKieSession());
                throw new IllegalStateException();
            }
            catch (TestGenCorruptedScoreException tgcse) {
                this.writer.setCorruptedScoreException(tgcse);
                this.writer.print(minJournal, this.testFile);
                throw this.wrapOriginalException(e);
            }
        }
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        this.journal.fireAllRules();
        return super.getConstraintMatchTotalMap();
    }

    @Override
    public void close() {
        this.journal.dispose();
        super.close();
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.journal.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    public void beforeVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        if (this.logger.isTraceEnabled()) {
            Object oldValue = variableDescriptor.getValue(entity);
            if (oldValue == null) {
                this.oldValues.push("null");
            } else {
                this.oldValues.push(oldValue.toString());
            }
        }
        super.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        super.afterVariableChanged(variableDescriptor, entity);
        this.journal.update(entity, variableDescriptor);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("          Updating variable {}.{}[{}]: {} \u2192 {}", new Object[]{entity, variableDescriptor.getVariableName(), variableDescriptor.getVariablePropertyType().getSimpleName(), this.oldValues.pop(), variableDescriptor.getValue(entity)});
        }
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.journal.delete(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.journal.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.journal.delete(problemFact);
        super.afterProblemFactRemoved(problemFact);
    }

    private RuntimeException wrapOriginalException(RuntimeException e) {
        return new RuntimeException(e.getMessage() + "\nDrools test written to: " + this.testFile.getAbsolutePath(), e);
    }
}

